/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs.export;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.logging.log4j2.f;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.AttributeKey;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.Attributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.metrics.LongCounter;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.metrics.Meter;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.metrics.MeterProvider;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.Context;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.CompletableResultCode;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.internal.DaemonThreadFactory;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs.LogRecordProcessor;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs.ReadWriteLogRecord;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs.data.LogRecordData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs.export.BatchLogRecordProcessorBuilder;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs.export.LogRecordExporter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class BatchLogRecordProcessor
implements LogRecordProcessor {
    private static final String WORKER_THREAD_NAME = BatchLogRecordProcessor.class.getSimpleName() + "_WorkerThread";
    private static final AttributeKey<String> LOG_RECORD_PROCESSOR_TYPE_LABEL = AttributeKey.stringKey("logRecordProcessorType");
    private static final AttributeKey<Boolean> LOG_RECORD_PROCESSOR_DROPPED_LABEL = AttributeKey.booleanKey("dropped");
    private static final String LOG_RECORD_PROCESSOR_TYPE_VALUE = BatchLogRecordProcessor.class.getSimpleName();
    private final Worker worker;
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);

    public static BatchLogRecordProcessorBuilder builder(LogRecordExporter logRecordExporter) {
        return new BatchLogRecordProcessorBuilder(logRecordExporter);
    }

    BatchLogRecordProcessor(LogRecordExporter logRecordExporter, MeterProvider meterProvider, long l2, int n2, int n3, long l3) {
        this.worker = new Worker(logRecordExporter, meterProvider, l2, n3, l3, new ArrayBlockingQueue(n2));
        Thread thread = new DaemonThreadFactory(WORKER_THREAD_NAME).newThread(this.worker);
        thread.start();
    }

    @Override
    public void onEmit(Context context, ReadWriteLogRecord readWriteLogRecord) {
        if (readWriteLogRecord == null) {
            return;
        }
        this.worker.addLog(readWriteLogRecord);
    }

    @Override
    public CompletableResultCode shutdown() {
        if (this.isShutdown.getAndSet(true)) {
            return CompletableResultCode.ofSuccess();
        }
        return this.worker.shutdown();
    }

    @Override
    public CompletableResultCode forceFlush() {
        return this.worker.forceFlush();
    }

    List<LogRecordData> getBatch() {
        return this.worker.batch;
    }

    public String toString() {
        return "BatchLogRecordProcessor{logRecordExporter=" + this.worker.logRecordExporter + ", scheduleDelayNanos=" + this.worker.scheduleDelayNanos + ", maxExportBatchSize=" + this.worker.maxExportBatchSize + ", exporterTimeoutNanos=" + this.worker.exporterTimeoutNanos + '}';
    }

    private static final class Worker
    implements Runnable {
        private static final f logger = f.a(Worker.class.getName());
        private final LongCounter processedLogsCounter;
        private final Attributes droppedAttrs;
        private final Attributes exportedAttrs;
        private final LogRecordExporter logRecordExporter;
        private final long scheduleDelayNanos;
        private final int maxExportBatchSize;
        private final long exporterTimeoutNanos;
        private long nextExportTime;
        private final Queue<ReadWriteLogRecord> queue;
        private final AtomicInteger logsNeeded = new AtomicInteger(Integer.MAX_VALUE);
        private final BlockingQueue<Boolean> signal;
        private final AtomicReference<CompletableResultCode> flushRequested = new AtomicReference();
        private volatile boolean continueWork = true;
        private final ArrayList<LogRecordData> batch;

        private Worker(LogRecordExporter logRecordExporter, MeterProvider meterProvider, long l2, int n2, long l3, Queue<ReadWriteLogRecord> queue) {
            this.logRecordExporter = logRecordExporter;
            this.scheduleDelayNanos = l2;
            this.maxExportBatchSize = n2;
            this.exporterTimeoutNanos = l3;
            this.queue = queue;
            this.signal = new ArrayBlockingQueue<Boolean>(1);
            Meter meter = meterProvider.meterBuilder("com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs").build();
            meter.gaugeBuilder("queueSize").ofLongs().setDescription("The number of logs queued").setUnit("1").buildWithCallback(observableLongMeasurement -> observableLongMeasurement.record(queue.size(), Attributes.of(LOG_RECORD_PROCESSOR_TYPE_LABEL, LOG_RECORD_PROCESSOR_TYPE_VALUE)));
            this.processedLogsCounter = meter.counterBuilder("processedLogs").setUnit("1").setDescription("The number of logs processed by the BatchLogRecordProcessor. [dropped=true if they were dropped due to high throughput]").build();
            this.droppedAttrs = Attributes.of(LOG_RECORD_PROCESSOR_TYPE_LABEL, LOG_RECORD_PROCESSOR_TYPE_VALUE, LOG_RECORD_PROCESSOR_DROPPED_LABEL, true);
            this.exportedAttrs = Attributes.of(LOG_RECORD_PROCESSOR_TYPE_LABEL, LOG_RECORD_PROCESSOR_TYPE_VALUE, LOG_RECORD_PROCESSOR_DROPPED_LABEL, false);
            this.batch = new ArrayList(this.maxExportBatchSize);
        }

        private void addLog(ReadWriteLogRecord readWriteLogRecord) {
            if (!this.queue.offer(readWriteLogRecord)) {
                this.processedLogsCounter.add(1L, this.droppedAttrs);
            } else if (this.queue.size() >= this.logsNeeded.get()) {
                this.signal.offer(true);
            }
        }

        @Override
        public void run() {
            this.updateNextExportTime();
            while (this.continueWork) {
                if (this.flushRequested.get() != null) {
                    this.flush();
                }
                while (!this.queue.isEmpty() && this.batch.size() < this.maxExportBatchSize) {
                    this.batch.add(this.queue.poll().toLogRecordData());
                }
                if (this.batch.size() >= this.maxExportBatchSize || System.nanoTime() >= this.nextExportTime) {
                    this.exportCurrentBatch();
                    this.updateNextExportTime();
                }
                if (!this.queue.isEmpty()) continue;
                try {
                    long l2 = this.nextExportTime - System.nanoTime();
                    if (l2 <= 0L) continue;
                    this.logsNeeded.set(this.maxExportBatchSize - this.batch.size());
                    this.signal.poll(l2, TimeUnit.NANOSECONDS);
                    this.logsNeeded.set(Integer.MAX_VALUE);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }

        private void flush() {
            Object object;
            for (int i2 = this.queue.size(); i2 > 0; --i2) {
                object = this.queue.poll();
                assert (object != null);
                this.batch.add(object.toLogRecordData());
                if (this.batch.size() < this.maxExportBatchSize) continue;
                this.exportCurrentBatch();
            }
            this.exportCurrentBatch();
            object = this.flushRequested.get();
            if (object != null) {
                ((CompletableResultCode)object).succeed();
                this.flushRequested.set(null);
            }
        }

        private void updateNextExportTime() {
            this.nextExportTime = System.nanoTime() + this.scheduleDelayNanos;
        }

        private CompletableResultCode shutdown() {
            CompletableResultCode completableResultCode = new CompletableResultCode();
            CompletableResultCode completableResultCode2 = this.forceFlush();
            completableResultCode2.whenComplete(() -> {
                this.continueWork = false;
                CompletableResultCode completableResultCode3 = this.logRecordExporter.shutdown();
                completableResultCode3.whenComplete(() -> {
                    if (!completableResultCode2.isSuccess() || !completableResultCode3.isSuccess()) {
                        completableResultCode.fail();
                    } else {
                        completableResultCode.succeed();
                    }
                });
            });
            return completableResultCode;
        }

        private CompletableResultCode forceFlush() {
            CompletableResultCode completableResultCode;
            CompletableResultCode completableResultCode2 = new CompletableResultCode();
            if (this.flushRequested.compareAndSet(null, completableResultCode2)) {
                this.signal.offer(true);
            }
            return (completableResultCode = this.flushRequested.get()) == null ? CompletableResultCode.ofSuccess() : completableResultCode;
        }

        private void exportCurrentBatch() {
            if (this.batch.isEmpty()) {
                return;
            }
            try {
                CompletableResultCode completableResultCode = this.logRecordExporter.export(Collections.unmodifiableList(this.batch));
                completableResultCode.join(this.exporterTimeoutNanos, TimeUnit.NANOSECONDS);
                if (completableResultCode.isSuccess()) {
                    this.processedLogsCounter.add(this.batch.size(), this.exportedAttrs);
                } else {
                    logger.a(f.a.f, "Exporter failed");
                }
            }
            catch (RuntimeException runtimeException) {
                Throwables.throwIfCritical(runtimeException);
                RuntimeException runtimeException2 = runtimeException;
                logger.a(f.a.c, "Exporter threw an Exception", runtimeException2);
            }
            finally {
                this.batch.clear();
            }
        }
    }
}

