/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs.export;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.logging.log4j2.f;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.CompletableResultCode;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs.data.LogRecordData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs.export.LogRecordExporter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

final class MultiLogRecordExporter
implements LogRecordExporter {
    private static final f logger = f.a(MultiLogRecordExporter.class.getName());
    private final LogRecordExporter[] logRecordExporters;

    private MultiLogRecordExporter(LogRecordExporter[] logRecordExporterArray) {
        this.logRecordExporters = logRecordExporterArray;
    }

    static LogRecordExporter create(List<LogRecordExporter> list) {
        return new MultiLogRecordExporter(list.toArray(new LogRecordExporter[0]));
    }

    @Override
    public CompletableResultCode export(Collection<LogRecordData> collection) {
        ArrayList<CompletableResultCode> arrayList = new ArrayList<CompletableResultCode>(this.logRecordExporters.length);
        for (LogRecordExporter logRecordExporter : this.logRecordExporters) {
            CompletableResultCode completableResultCode;
            try {
                completableResultCode = logRecordExporter.export(collection);
            }
            catch (RuntimeException runtimeException) {
                Throwables.throwIfCritical(runtimeException);
                RuntimeException runtimeException2 = runtimeException;
                logger.a(f.a.c, "Exception thrown by the export.", runtimeException2);
                arrayList.add(CompletableResultCode.ofFailure());
                continue;
            }
            arrayList.add(completableResultCode);
        }
        return CompletableResultCode.ofAll(arrayList);
    }

    @Override
    public CompletableResultCode flush() {
        ArrayList<CompletableResultCode> arrayList = new ArrayList<CompletableResultCode>(this.logRecordExporters.length);
        for (LogRecordExporter logRecordExporter : this.logRecordExporters) {
            CompletableResultCode completableResultCode;
            try {
                completableResultCode = logRecordExporter.flush();
            }
            catch (RuntimeException runtimeException) {
                Throwables.throwIfCritical(runtimeException);
                RuntimeException runtimeException2 = runtimeException;
                logger.a(f.a.c, "Exception thrown by the flush.", runtimeException2);
                arrayList.add(CompletableResultCode.ofFailure());
                continue;
            }
            arrayList.add(completableResultCode);
        }
        return CompletableResultCode.ofAll(arrayList);
    }

    @Override
    public CompletableResultCode shutdown() {
        ArrayList<CompletableResultCode> arrayList = new ArrayList<CompletableResultCode>(this.logRecordExporters.length);
        for (LogRecordExporter logRecordExporter : this.logRecordExporters) {
            CompletableResultCode completableResultCode;
            try {
                completableResultCode = logRecordExporter.shutdown();
            }
            catch (RuntimeException runtimeException) {
                Throwables.throwIfCritical(runtimeException);
                RuntimeException runtimeException2 = runtimeException;
                logger.a(f.a.c, "Exception thrown by the shutdown.", runtimeException2);
                arrayList.add(CompletableResultCode.ofFailure());
                continue;
            }
            arrayList.add(completableResultCode);
        }
        return CompletableResultCode.ofAll(arrayList);
    }

    public String toString() {
        return "MultiLogRecordExporter{logRecordExporters=" + Arrays.toString(this.logRecordExporters) + '}';
    }
}

