/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs.internal;

import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.AttributeKey;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.Attributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.events.EventEmitter;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.events.EventEmitterBuilder;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.events.EventEmitterProvider;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.logs.Logger;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.logs.LoggerBuilder;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.logs.LoggerProvider;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.Clock;
import java.util.concurrent.TimeUnit;

public final class SdkEventEmitterProvider
implements EventEmitterProvider {
    private static final String DEFAULT_EVENT_DOMAIN = "unknown";
    private final LoggerProvider delegateLoggerProvider;
    private final Clock clock;

    private SdkEventEmitterProvider(LoggerProvider loggerProvider, Clock clock) {
        this.delegateLoggerProvider = loggerProvider;
        this.clock = clock;
    }

    public static SdkEventEmitterProvider create(LoggerProvider loggerProvider) {
        return new SdkEventEmitterProvider(loggerProvider, Clock.getDefault());
    }

    public static SdkEventEmitterProvider create(LoggerProvider loggerProvider, Clock clock) {
        return new SdkEventEmitterProvider(loggerProvider, clock);
    }

    @Override
    public EventEmitter get(String string) {
        return this.eventEmitterBuilder(string).setEventDomain(DEFAULT_EVENT_DOMAIN).build();
    }

    @Override
    public EventEmitterBuilder eventEmitterBuilder(String string) {
        return new SdkEventEmitterBuilder(this.clock, this.delegateLoggerProvider.loggerBuilder(string));
    }

    private static class SdkEventEmitterBuilder
    implements EventEmitterBuilder {
        private final Clock clock;
        private final LoggerBuilder delegateLoggerBuilder;
        private String eventDomain = "unknown";

        private SdkEventEmitterBuilder(Clock clock, LoggerBuilder loggerBuilder) {
            this.clock = clock;
            this.delegateLoggerBuilder = loggerBuilder;
        }

        @Override
        public EventEmitterBuilder setEventDomain(String string) {
            this.eventDomain = string;
            return this;
        }

        @Override
        public EventEmitterBuilder setSchemaUrl(String string) {
            this.delegateLoggerBuilder.setSchemaUrl(string);
            return this;
        }

        @Override
        public EventEmitterBuilder setInstrumentationVersion(String string) {
            this.delegateLoggerBuilder.setInstrumentationVersion(string);
            return this;
        }

        @Override
        public EventEmitter build() {
            return new SdkEventEmitter(this.clock, this.delegateLoggerBuilder.build(), this.eventDomain);
        }
    }

    private static class SdkEventEmitter
    implements EventEmitter {
        private static final AttributeKey<String> EVENT_DOMAIN = AttributeKey.stringKey("event.domain");
        private static final AttributeKey<String> EVENT_NAME = AttributeKey.stringKey("event.name");
        private final Clock clock;
        private final Logger delegateLogger;
        private final String eventDomain;

        private SdkEventEmitter(Clock clock, Logger logger, String string) {
            this.clock = clock;
            this.delegateLogger = logger;
            this.eventDomain = string;
        }

        @Override
        public void emit(String string, Attributes attributes) {
            this.delegateLogger.logRecordBuilder().setTimestamp(this.clock.now(), TimeUnit.NANOSECONDS).setAllAttributes(attributes).setAttribute(EVENT_DOMAIN, this.eventDomain).setAttribute(EVENT_NAME, string).emit();
        }
    }
}

