/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics;

import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.Aggregation;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.View;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.view.AttributesProcessor;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public final class ViewBuilder {
    @Nullable
    private String name;
    @Nullable
    private String description;
    private Aggregation aggregation = Aggregation.defaultAggregation();
    private AttributesProcessor processor = AttributesProcessor.noop();
    private int cardinalityLimit = 2000;

    ViewBuilder() {
    }

    public ViewBuilder setName(String string) {
        this.name = string;
        return this;
    }

    public ViewBuilder setDescription(String string) {
        this.description = string;
        return this;
    }

    public ViewBuilder setAggregation(Aggregation aggregation) {
        if (!(aggregation instanceof AggregatorFactory)) {
            throw new IllegalArgumentException("Custom Aggregation implementations are currently not supported. Use one of the standard implementations returned by the static factories in the Aggregation class.");
        }
        this.aggregation = aggregation;
        return this;
    }

    public ViewBuilder setAttributeFilter(Predicate<String> predicate) {
        Objects.requireNonNull(predicate, "keyFilter");
        return this.addAttributesProcessor(AttributesProcessor.filterByKeyName(predicate));
    }

    ViewBuilder addAttributesProcessor(AttributesProcessor attributesProcessor) {
        this.processor = this.processor.then(attributesProcessor);
        return this;
    }

    ViewBuilder setCardinalityLimit(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("cardinalityLimit must be > 0");
        }
        this.cardinalityLimit = n2;
        return this;
    }

    public View build() {
        return View.create(this.name, this.description, this.aggregation, this.processor, this.cardinalityLimit);
    }
}

