/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class Base2ExponentialHistogramIndexer {
    private static final Map<Integer, Base2ExponentialHistogramIndexer> cache = new ConcurrentHashMap<Integer, Base2ExponentialHistogramIndexer>();
    private static final long EXPONENT_BIT_MASK = 0x7FF0000000000000L;
    private static final long SIGNIFICAND_BIT_MASK = 0xFFFFFFFFFFFFFL;
    private static final int EXPONENT_BIAS = 1023;
    private static final int SIGNIFICAND_WIDTH = 52;
    private static final int EXPONENT_WIDTH = 11;
    private static final double LOG_BASE2_E = 1.0 / Math.log(2.0);
    private final int scale;
    private final double scaleFactor;

    private Base2ExponentialHistogramIndexer(int n2) {
        this.scale = n2;
        this.scaleFactor = Base2ExponentialHistogramIndexer.computeScaleFactor(n2);
    }

    static Base2ExponentialHistogramIndexer get(int n2) {
        return cache.computeIfAbsent(n2, n3 -> new Base2ExponentialHistogramIndexer(n2));
    }

    int computeIndex(double d2) {
        double d3 = Math.abs(d2);
        if (this.scale > 0) {
            return this.getIndexByLogarithm(d3);
        }
        if (this.scale == 0) {
            return Base2ExponentialHistogramIndexer.mapToIndexScaleZero(d3);
        }
        return Base2ExponentialHistogramIndexer.mapToIndexScaleZero(d3) >> -this.scale;
    }

    private int getIndexByLogarithm(double d2) {
        return (int)Math.ceil(Math.log(d2) * this.scaleFactor) - 1;
    }

    private static int mapToIndexScaleZero(double d2) {
        long l2 = Double.doubleToLongBits(d2);
        long l3 = (l2 & 0x7FF0000000000000L) >> 52;
        long l4 = l2 & 0xFFFFFFFFFFFFFL;
        if (l3 == 0L) {
            l3 -= (long)(Long.numberOfLeadingZeros(l4 - 1L) - 11 - 1);
        }
        int n2 = (int)(l3 - 1023L);
        if (l4 == 0L) {
            return n2 - 1;
        }
        return n2;
    }

    private static double computeScaleFactor(int n2) {
        return Math.scalb(LOG_BASE2_E, n2);
    }
}

