/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator;

import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.Attributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.DoublePointData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.MetricData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.data.ImmutableDoublePointData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.data.ImmutableGaugeData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.state.Measurement;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.resources.Resource;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class DoubleLastValueAggregator
implements Aggregator<DoublePointData, DoubleExemplarData> {
    private final Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier;

    public DoubleLastValueAggregator(Supplier<ExemplarReservoir<DoubleExemplarData>> supplier) {
        this.reservoirSupplier = supplier;
    }

    @Override
    public AggregatorHandle<DoublePointData, DoubleExemplarData> createHandle() {
        return new Handle(this.reservoirSupplier.get());
    }

    @Override
    public DoublePointData diff(DoublePointData doublePointData, DoublePointData doublePointData2) {
        return doublePointData2;
    }

    @Override
    public DoublePointData toPoint(Measurement measurement) {
        return ImmutableDoublePointData.create(measurement.startEpochNanos(), measurement.epochNanos(), measurement.attributes(), measurement.doubleValue());
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor metricDescriptor, Collection<DoublePointData> collection, AggregationTemporality aggregationTemporality) {
        return ImmutableMetricData.createDoubleGauge(resource, instrumentationScopeInfo, metricDescriptor.getName(), metricDescriptor.getDescription(), metricDescriptor.getSourceInstrument().getUnit(), ImmutableGaugeData.create(collection));
    }

    static final class Handle
    extends AggregatorHandle<DoublePointData, DoubleExemplarData> {
        @Nullable
        private static final Double DEFAULT_VALUE = null;
        private final AtomicReference<Double> current = new AtomicReference<Double>(DEFAULT_VALUE);

        private Handle(ExemplarReservoir<DoubleExemplarData> exemplarReservoir) {
            super(exemplarReservoir);
        }

        @Override
        protected DoublePointData doAggregateThenMaybeReset(long l2, long l3, Attributes attributes, List<DoubleExemplarData> list, boolean bl2) {
            Double d2 = bl2 ? this.current.getAndSet(DEFAULT_VALUE) : this.current.get();
            return ImmutableDoublePointData.create(l2, l3, attributes, Objects.requireNonNull(d2), list);
        }

        @Override
        protected void doRecordDouble(double d2) {
            this.current.set(d2);
        }
    }
}

