/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator;

import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.Attributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.LongExemplarData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.LongPointData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.MetricData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator.AbstractSumAggregator;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.concurrent.AdderUtil;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.concurrent.LongAdder;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.data.ImmutableLongPointData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.data.ImmutableSumData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.state.Measurement;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.resources.Resource;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;

public final class LongSumAggregator
extends AbstractSumAggregator<LongPointData, LongExemplarData> {
    private final Supplier<ExemplarReservoir<LongExemplarData>> reservoirSupplier;

    public LongSumAggregator(InstrumentDescriptor instrumentDescriptor, Supplier<ExemplarReservoir<LongExemplarData>> supplier) {
        super(instrumentDescriptor);
        this.reservoirSupplier = supplier;
    }

    @Override
    public AggregatorHandle<LongPointData, LongExemplarData> createHandle() {
        return new Handle(this.reservoirSupplier.get());
    }

    @Override
    public LongPointData diff(LongPointData longPointData, LongPointData longPointData2) {
        return ImmutableLongPointData.create(longPointData2.getStartEpochNanos(), longPointData2.getEpochNanos(), longPointData2.getAttributes(), longPointData2.getValue() - longPointData.getValue(), longPointData2.getExemplars());
    }

    @Override
    public LongPointData toPoint(Measurement measurement) {
        return ImmutableLongPointData.create(measurement.startEpochNanos(), measurement.epochNanos(), measurement.attributes(), measurement.longValue());
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor metricDescriptor, Collection<LongPointData> collection, AggregationTemporality aggregationTemporality) {
        return ImmutableMetricData.createLongSum(resource, instrumentationScopeInfo, metricDescriptor.getName(), metricDescriptor.getDescription(), metricDescriptor.getSourceInstrument().getUnit(), ImmutableSumData.create(this.isMonotonic(), aggregationTemporality, collection));
    }

    static final class Handle
    extends AggregatorHandle<LongPointData, LongExemplarData> {
        private final LongAdder current = AdderUtil.createLongAdder();

        Handle(ExemplarReservoir<LongExemplarData> exemplarReservoir) {
            super(exemplarReservoir);
        }

        @Override
        protected LongPointData doAggregateThenMaybeReset(long l2, long l3, Attributes attributes, List<LongExemplarData> list, boolean bl2) {
            long l4 = bl2 ? this.current.sumThenReset() : this.current.sum();
            return ImmutableLongPointData.create(l2, l3, attributes, l4, list);
        }

        @Override
        public void doRecordLong(long l2) {
            this.current.add(l2);
        }
    }
}

