/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.state;

import com.contrastsecurity.agent.logging.log4j2.f;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.Attributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.Context;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.internal.ThrottlingLogger;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.View;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.ExemplarData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.MetricData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.PointData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.export.RegisteredReader;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.state.Measurement;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.state.MetricStorage;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.view.AttributesProcessor;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.view.RegisteredView;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.resources.Resource;
import java.util.HashMap;
import java.util.Map;

final class AsynchronousMetricStorage<T extends PointData, U extends ExemplarData>
implements MetricStorage {
    private static final f logger = f.a(AsynchronousMetricStorage.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final RegisteredReader registeredReader;
    private final MetricDescriptor metricDescriptor;
    private final AggregationTemporality aggregationTemporality;
    private final Aggregator<T, U> aggregator;
    private final AttributesProcessor attributesProcessor;
    private final int maxCardinality;
    private Map<Attributes, T> points = new HashMap<Attributes, T>();
    private Map<Attributes, T> lastPoints = new HashMap<Attributes, T>();

    private AsynchronousMetricStorage(RegisteredReader registeredReader, MetricDescriptor metricDescriptor, Aggregator<T, U> aggregator, AttributesProcessor attributesProcessor, int n2) {
        this.registeredReader = registeredReader;
        this.metricDescriptor = metricDescriptor;
        this.aggregationTemporality = registeredReader.getReader().getAggregationTemporality(metricDescriptor.getSourceInstrument().getType());
        this.aggregator = aggregator;
        this.attributesProcessor = attributesProcessor;
        this.maxCardinality = n2 - 1;
    }

    static <T extends PointData, U extends ExemplarData> AsynchronousMetricStorage<T, U> create(RegisteredReader registeredReader, RegisteredView registeredView, InstrumentDescriptor instrumentDescriptor) {
        View view = registeredView.getView();
        MetricDescriptor metricDescriptor = MetricDescriptor.create(view, registeredView.getViewSourceInfo(), instrumentDescriptor);
        Aggregator aggregator = ((AggregatorFactory)((Object)view.getAggregation())).createAggregator(instrumentDescriptor, ExemplarFilter.alwaysOff());
        return new AsynchronousMetricStorage(registeredReader, metricDescriptor, aggregator, registeredView.getViewAttributesProcessor(), registeredView.getCardinalityLimit());
    }

    void record(Measurement measurement) {
        Context context = Context.current();
        Attributes attributes = this.attributesProcessor.process(measurement.attributes(), context);
        long l2 = this.aggregationTemporality == AggregationTemporality.DELTA ? this.registeredReader.getLastCollectEpochNanos() : measurement.startEpochNanos();
        measurement = measurement.hasDoubleValue() ? Measurement.doubleMeasurement(l2, measurement.epochNanos(), measurement.doubleValue(), attributes) : Measurement.longMeasurement(l2, measurement.epochNanos(), measurement.longValue(), attributes);
        this.recordPoint(attributes, measurement);
    }

    private void recordPoint(Attributes attributes, Measurement measurement) {
        if (this.points.size() >= this.maxCardinality) {
            this.throttlingLogger.log(f.a.c, "Instrument " + this.metricDescriptor.getSourceInstrument().getName() + " has exceeded the maximum allowed cardinality (" + this.maxCardinality + ").");
            attributes = MetricStorage.CARDINALITY_OVERFLOW;
            measurement = measurement.hasDoubleValue() ? Measurement.doubleMeasurement(measurement.startEpochNanos(), measurement.epochNanos(), measurement.doubleValue(), attributes) : Measurement.longMeasurement(measurement.startEpochNanos(), measurement.epochNanos(), measurement.longValue(), attributes);
        } else if (this.points.containsKey(attributes)) {
            this.throttlingLogger.log(f.a.c, "Instrument " + this.metricDescriptor.getSourceInstrument().getName() + " has recorded multiple values for the same attributes: " + attributes);
            return;
        }
        this.points.put(attributes, this.aggregator.toPoint(measurement));
    }

    @Override
    public MetricDescriptor getMetricDescriptor() {
        return this.metricDescriptor;
    }

    public RegisteredReader getRegisteredReader() {
        return this.registeredReader;
    }

    @Override
    public MetricData collect(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, long l2, long l3) {
        Map<Attributes, T> map;
        if (this.aggregationTemporality == AggregationTemporality.DELTA) {
            Map map2 = this.points;
            Map<Attributes, T> map3 = this.lastPoints;
            map3.entrySet().removeIf(entry -> !map2.containsKey(entry.getKey()));
            map2.forEach((attributes2, pointData) -> map3.compute((Attributes)attributes2, (attributes, pointData2) -> pointData2 == null ? pointData : this.aggregator.diff((PointData)pointData2, (PointData)pointData)));
            map = map3;
            this.lastPoints = map2;
        } else {
            map = this.points;
        }
        this.points = new HashMap<Attributes, T>();
        return this.aggregator.toMetricData(resource, instrumentationScopeInfo, this.metricDescriptor, map.values(), this.aggregationTemporality);
    }

    @Override
    public boolean isEmpty() {
        return this.aggregator == Aggregator.drop();
    }
}

