/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.state;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.logging.log4j2.f;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.internal.ThrottlingLogger;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.internal.ThrowableUtil;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.export.RegisteredReader;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.state.SdkObservableMeasurement;
import java.util.List;
import java.util.stream.Collectors;

public final class CallbackRegistration {
    private static final f logger = f.a(CallbackRegistration.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final List<SdkObservableMeasurement> observableMeasurements;
    private final Runnable callback;
    private final List<InstrumentDescriptor> instrumentDescriptors;
    private final boolean hasStorages;

    private CallbackRegistration(List<SdkObservableMeasurement> list, Runnable runnable) {
        this.observableMeasurements = list;
        this.callback = runnable;
        this.instrumentDescriptors = list.stream().map(SdkObservableMeasurement::getInstrumentDescriptor).collect(Collectors.toList());
        if (this.instrumentDescriptors.size() == 0) {
            throw new IllegalStateException("Callback with no instruments is not allowed");
        }
        this.hasStorages = list.stream().flatMap(sdkObservableMeasurement -> sdkObservableMeasurement.getStorages().stream()).findAny().isPresent();
    }

    public static CallbackRegistration create(List<SdkObservableMeasurement> list, Runnable runnable) {
        return new CallbackRegistration(list, runnable);
    }

    public String toString() {
        return "CallbackRegistration{instrumentDescriptors=" + this.instrumentDescriptors + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeCallback(RegisteredReader registeredReader, long l2, long l3) {
        if (!this.hasStorages) {
            return;
        }
        this.observableMeasurements.forEach(sdkObservableMeasurement -> sdkObservableMeasurement.setActiveReader(registeredReader, l2, l3));
        try {
            this.callback.run();
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            ThrowableUtil.propagateIfFatal(throwable2);
            this.throttlingLogger.log(f.a.c, "An exception occurred invoking callback for " + this + ".", throwable2);
        }
        finally {
            this.observableMeasurements.forEach(SdkObservableMeasurement::unsetActiveReader);
        }
    }
}

