/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.state;

import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.Aggregation;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.MetricData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.export.RegisteredReader;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.state.AsynchronousMetricStorage;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.state.CallbackRegistration;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.state.MetricStorage;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.state.MetricStorageRegistry;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.state.MultiWritableMetricStorage;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.state.SdkObservableMeasurement;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.state.SynchronousMetricStorage;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.view.RegisteredView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MeterSharedState {
    private final Object collectLock = new Object();
    private final Object callbackLock = new Object();
    private final List<CallbackRegistration> callbackRegistrations = new ArrayList<CallbackRegistration>();
    private final Map<RegisteredReader, MetricStorageRegistry> readerStorageRegistries;
    private final InstrumentationScopeInfo instrumentationScopeInfo;

    private MeterSharedState(InstrumentationScopeInfo instrumentationScopeInfo, List<RegisteredReader> list) {
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.readerStorageRegistries = list.stream().collect(Collectors.toMap(Function.identity(), registeredReader -> new MetricStorageRegistry()));
    }

    public static MeterSharedState create(InstrumentationScopeInfo instrumentationScopeInfo, List<RegisteredReader> list) {
        return new MeterSharedState(instrumentationScopeInfo, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallback(CallbackRegistration callbackRegistration) {
        Object object = this.callbackLock;
        synchronized (object) {
            this.callbackRegistrations.remove(callbackRegistration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerCallback(CallbackRegistration callbackRegistration) {
        Object object = this.callbackLock;
        synchronized (object) {
            this.callbackRegistrations.add(callbackRegistration);
        }
    }

    public InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MetricData> collectAll(RegisteredReader registeredReader, MeterProviderSharedState meterProviderSharedState, long l2) {
        ArrayList<CallbackRegistration> arrayList;
        Object object = this.callbackLock;
        synchronized (object) {
            arrayList = new ArrayList<CallbackRegistration>(this.callbackRegistrations);
        }
        object = this.collectLock;
        synchronized (object) {
            for (CallbackRegistration object22 : arrayList) {
                object22.invokeCallback(registeredReader, meterProviderSharedState.getStartEpochNanos(), l2);
            }
            Collection<MetricStorage> collection = Objects.requireNonNull(this.readerStorageRegistries.get(registeredReader)).getStorages();
            ArrayList<MetricData> arrayList2 = new ArrayList<MetricData>(collection.size());
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                MetricStorage metricStorage = (MetricStorage)iterator.next();
                MetricData metricData = metricStorage.collect(meterProviderSharedState.getResource(), this.getInstrumentationScopeInfo(), meterProviderSharedState.getStartEpochNanos(), l2);
                if (metricData.isEmpty()) continue;
                arrayList2.add(metricData);
            }
            return arrayList2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetForTest() {
        Object object = this.collectLock;
        synchronized (object) {
            Object object2 = this.callbackLock;
            synchronized (object2) {
                this.callbackRegistrations.clear();
            }
            this.readerStorageRegistries.values().forEach(MetricStorageRegistry::resetForTest);
        }
    }

    public final WriteableMetricStorage registerSynchronousMetricStorage(InstrumentDescriptor instrumentDescriptor, MeterProviderSharedState meterProviderSharedState) {
        ArrayList<SynchronousMetricStorage> arrayList = new ArrayList<SynchronousMetricStorage>();
        for (Map.Entry<RegisteredReader, MetricStorageRegistry> entry : this.readerStorageRegistries.entrySet()) {
            RegisteredReader registeredReader = entry.getKey();
            MetricStorageRegistry metricStorageRegistry = entry.getValue();
            for (RegisteredView registeredView : registeredReader.getViewRegistry().findViews(instrumentDescriptor, this.getInstrumentationScopeInfo())) {
                if (Aggregation.drop() == registeredView.getView().getAggregation()) continue;
                arrayList.add(metricStorageRegistry.register(SynchronousMetricStorage.create(registeredReader, registeredView, instrumentDescriptor, meterProviderSharedState.getExemplarFilter())));
            }
        }
        if (arrayList.size() == 1) {
            return (WriteableMetricStorage)arrayList.get(0);
        }
        return new MultiWritableMetricStorage(arrayList);
    }

    public final SdkObservableMeasurement registerObservableMeasurement(InstrumentDescriptor instrumentDescriptor) {
        ArrayList arrayList = new ArrayList();
        for (Map.Entry<RegisteredReader, MetricStorageRegistry> entry : this.readerStorageRegistries.entrySet()) {
            RegisteredReader registeredReader = entry.getKey();
            MetricStorageRegistry metricStorageRegistry = entry.getValue();
            for (RegisteredView registeredView : registeredReader.getViewRegistry().findViews(instrumentDescriptor, this.getInstrumentationScopeInfo())) {
                if (Aggregation.drop() == registeredView.getView().getAggregation()) continue;
                arrayList.add(metricStorageRegistry.register(AsynchronousMetricStorage.create(registeredReader, registeredView, instrumentDescriptor)));
            }
        }
        return SdkObservableMeasurement.create(this.instrumentationScopeInfo, instrumentDescriptor, arrayList);
    }
}

