/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.view;

import com.contrastsecurity.thirdparty.io.opentelemetry.api.baggage.Baggage;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.Attributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.AttributesBuilder;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.Context;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.view.NoopAttributesProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class AttributesProcessor {
    AttributesProcessor() {
    }

    public abstract Attributes process(Attributes var1, Context var2);

    public abstract boolean usesContext();

    public AttributesProcessor then(AttributesProcessor attributesProcessor) {
        if (attributesProcessor == NoopAttributesProcessor.NOOP) {
            return this;
        }
        if (this == NoopAttributesProcessor.NOOP) {
            return attributesProcessor;
        }
        if (attributesProcessor instanceof JoinedAttributesProcessor) {
            return ((JoinedAttributesProcessor)attributesProcessor).prepend(this);
        }
        return new JoinedAttributesProcessor(Arrays.asList(this, attributesProcessor));
    }

    public static AttributesProcessor noop() {
        return NoopAttributesProcessor.NOOP;
    }

    public static AttributesProcessor filterByKeyName(Predicate<String> predicate) {
        return AttributesProcessor.simple(attributes -> attributes.toBuilder().removeIf(attributeKey -> !predicate.test(attributeKey.getKey())).build());
    }

    public static AttributesProcessor appendBaggageByKeyName(Predicate<String> predicate) {
        return AttributesProcessor.onBaggage((attributes, baggage) -> {
            AttributesBuilder attributesBuilder = Attributes.builder();
            baggage.forEach((string, baggageEntry) -> {
                if (predicate.test((String)string)) {
                    attributesBuilder.put((String)string, baggageEntry.getValue());
                }
            });
            attributesBuilder.putAll((Attributes)attributes);
            return attributesBuilder.build();
        });
    }

    public static AttributesProcessor append(Attributes attributes) {
        return AttributesProcessor.simple(attributes2 -> attributes.toBuilder().putAll((Attributes)attributes2).build());
    }

    static AttributesProcessor simple(final UnaryOperator<Attributes> unaryOperator) {
        return new AttributesProcessor(){

            @Override
            public Attributes process(Attributes attributes, Context context) {
                return (Attributes)unaryOperator.apply(attributes);
            }

            @Override
            public boolean usesContext() {
                return false;
            }
        };
    }

    static AttributesProcessor onBaggage(final BiFunction<Attributes, Baggage, Attributes> biFunction) {
        return new AttributesProcessor(){

            @Override
            public Attributes process(Attributes attributes, Context context) {
                return (Attributes)biFunction.apply(attributes, Baggage.fromContext(context));
            }

            @Override
            public boolean usesContext() {
                return true;
            }
        };
    }

    @Immutable
    static final class JoinedAttributesProcessor
    extends AttributesProcessor {
        private final Collection<AttributesProcessor> processors;
        private final boolean usesContextCache;

        JoinedAttributesProcessor(Collection<AttributesProcessor> collection) {
            this.processors = collection;
            this.usesContextCache = collection.stream().map(AttributesProcessor::usesContext).reduce(false, (bl2, bl3) -> bl2 != false || bl3 != false);
        }

        @Override
        public Attributes process(Attributes attributes, Context context) {
            Attributes attributes2 = attributes;
            for (AttributesProcessor attributesProcessor : this.processors) {
                attributes2 = attributesProcessor.process(attributes2, context);
            }
            return attributes2;
        }

        @Override
        public boolean usesContext() {
            return this.usesContextCache;
        }

        @Override
        public AttributesProcessor then(AttributesProcessor attributesProcessor) {
            ArrayList<AttributesProcessor> arrayList = new ArrayList<AttributesProcessor>(this.processors);
            if (attributesProcessor instanceof JoinedAttributesProcessor) {
                arrayList.addAll(((JoinedAttributesProcessor)attributesProcessor).processors);
            } else {
                arrayList.add(attributesProcessor);
            }
            return new JoinedAttributesProcessor(arrayList);
        }

        AttributesProcessor prepend(AttributesProcessor attributesProcessor) {
            ArrayList<AttributesProcessor> arrayList = new ArrayList<AttributesProcessor>(this.processors.size() + 1);
            arrayList.add(attributesProcessor);
            arrayList.addAll(this.processors);
            return new JoinedAttributesProcessor(arrayList);
        }
    }
}

