/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.view;

import com.contrastsecurity.agent.logging.log4j2.f;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.internal.ThrottlingLogger;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.Aggregation;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.ExemplarData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.PointData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.view.DropAggregation;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.view.ExplicitBucketHistogramAggregation;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.view.LastValueAggregation;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.view.SumAggregation;

public final class DefaultAggregation
implements Aggregation,
AggregatorFactory {
    private static final Aggregation INSTANCE = new DefaultAggregation();
    private static final ThrottlingLogger logger = new ThrottlingLogger(f.a(DefaultAggregation.class.getName()));

    public static Aggregation getInstance() {
        return INSTANCE;
    }

    private DefaultAggregation() {
    }

    private static Aggregation resolve(InstrumentDescriptor instrumentDescriptor, boolean bl2) {
        switch (instrumentDescriptor.getType()) {
            case COUNTER: 
            case UP_DOWN_COUNTER: 
            case OBSERVABLE_COUNTER: 
            case OBSERVABLE_UP_DOWN_COUNTER: {
                return SumAggregation.getInstance();
            }
            case HISTOGRAM: {
                if (bl2 && instrumentDescriptor.getAdvice().getExplicitBucketBoundaries() != null) {
                    return ExplicitBucketHistogramAggregation.create(instrumentDescriptor.getAdvice().getExplicitBucketBoundaries());
                }
                return ExplicitBucketHistogramAggregation.getDefault();
            }
            case OBSERVABLE_GAUGE: {
                return LastValueAggregation.getInstance();
            }
        }
        logger.log(f.a.c, "Unable to find default aggregation for instrument: " + instrumentDescriptor);
        return DropAggregation.getInstance();
    }

    @Override
    public <T extends PointData, U extends ExemplarData> Aggregator<T, U> createAggregator(InstrumentDescriptor instrumentDescriptor, ExemplarFilter exemplarFilter) {
        return ((AggregatorFactory)((Object)DefaultAggregation.resolve(instrumentDescriptor, true))).createAggregator(instrumentDescriptor, exemplarFilter);
    }

    @Override
    public boolean isCompatibleWithInstrument(InstrumentDescriptor instrumentDescriptor) {
        return ((AggregatorFactory)((Object)DefaultAggregation.resolve(instrumentDescriptor, false))).isCompatibleWithInstrument(instrumentDescriptor);
    }

    public String toString() {
        return "DefaultAggregation";
    }
}

