/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.view;

import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.Aggregation;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.InstrumentType;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.ExemplarData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.PointData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator.DoubleLastValueAggregator;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator.LongLastValueAggregator;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;

public final class LastValueAggregation
implements Aggregation,
AggregatorFactory {
    private static final Aggregation INSTANCE = new LastValueAggregation();

    public static Aggregation getInstance() {
        return INSTANCE;
    }

    private LastValueAggregation() {
    }

    @Override
    public <T extends PointData, U extends ExemplarData> Aggregator<T, U> createAggregator(InstrumentDescriptor instrumentDescriptor, ExemplarFilter exemplarFilter) {
        switch (instrumentDescriptor.getValueType()) {
            case LONG: {
                return new LongLastValueAggregator(ExemplarReservoir::longNoSamples);
            }
            case DOUBLE: {
                return new DoubleLastValueAggregator(ExemplarReservoir::doubleNoSamples);
            }
        }
        throw new IllegalArgumentException("Invalid instrument value type");
    }

    @Override
    public boolean isCompatibleWithInstrument(InstrumentDescriptor instrumentDescriptor) {
        return instrumentDescriptor.getType() == InstrumentType.OBSERVABLE_GAUGE;
    }

    public String toString() {
        return "LastValueAggregation";
    }
}

