/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.view;

import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.Clock;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.internal.RandomSupplier;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.Aggregation;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.ExemplarData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.LongExemplarData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.PointData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator.DoubleSumAggregator;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator.LongSumAggregator;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import java.util.function.Supplier;

public final class SumAggregation
implements Aggregation,
AggregatorFactory {
    private static final SumAggregation INSTANCE = new SumAggregation();

    public static Aggregation getInstance() {
        return INSTANCE;
    }

    private SumAggregation() {
    }

    @Override
    public <T extends PointData, U extends ExemplarData> Aggregator<T, U> createAggregator(InstrumentDescriptor instrumentDescriptor, ExemplarFilter exemplarFilter) {
        switch (instrumentDescriptor.getValueType()) {
            case LONG: {
                Supplier<ExemplarReservoir<LongExemplarData>> supplier = () -> ExemplarReservoir.filtered(exemplarFilter, ExemplarReservoir.longFixedSizeReservoir(Clock.getDefault(), Runtime.getRuntime().availableProcessors(), RandomSupplier.platformDefault()));
                return new LongSumAggregator(instrumentDescriptor, supplier);
            }
            case DOUBLE: {
                Supplier<ExemplarReservoir<DoubleExemplarData>> supplier = () -> ExemplarReservoir.filtered(exemplarFilter, ExemplarReservoir.doubleFixedSizeReservoir(Clock.getDefault(), Runtime.getRuntime().availableProcessors(), RandomSupplier.platformDefault()));
                return new DoubleSumAggregator(instrumentDescriptor, supplier);
            }
        }
        throw new IllegalArgumentException("Invalid instrument value type");
    }

    @Override
    public boolean isCompatibleWithInstrument(InstrumentDescriptor instrumentDescriptor) {
        switch (instrumentDescriptor.getType()) {
            case COUNTER: 
            case OBSERVABLE_COUNTER: 
            case UP_DOWN_COUNTER: 
            case OBSERVABLE_UP_DOWN_COUNTER: 
            case HISTOGRAM: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "SumAggregation";
    }
}

