/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace;

import com.contrastsecurity.agent.logging.log4j2.f;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.AttributeKey;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.Attributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.Span;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.SpanContext;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.SpanKind;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.StatusCode;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.Context;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.Clock;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.internal.AttributeUtil;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.internal.AttributesMap;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.internal.InstrumentationScopeUtil;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.resources.Resource;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.AnchoredClock;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.ReadWriteSpan;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.SpanLimits;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.SpanProcessor;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.SpanWrapper;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.data.EventData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.data.LinkData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.data.SpanData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.data.StatusData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.internal.data.ExceptionEventData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class SdkSpan
implements ReadWriteSpan {
    private static final f logger = f.a(SdkSpan.class.getName());
    private final SpanLimits spanLimits;
    private final SpanContext context;
    private final SpanContext parentSpanContext;
    private final SpanProcessor spanProcessor;
    private final List<LinkData> links;
    private final int totalRecordedLinks;
    private final SpanKind kind;
    private final AnchoredClock clock;
    private final Resource resource;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final long startEpochNanos;
    private final Object lock = new Object();
    private String name;
    @Nullable
    private AttributesMap attributes;
    private final List<EventData> events;
    private int totalRecordedEvents = 0;
    private StatusData status = StatusData.unset();
    private long endEpochNanos;
    private boolean hasEnded;

    private SdkSpan(SpanContext spanContext, String string, InstrumentationScopeInfo instrumentationScopeInfo, SpanKind spanKind, SpanContext spanContext2, SpanLimits spanLimits, SpanProcessor spanProcessor, AnchoredClock anchoredClock, Resource resource, @Nullable AttributesMap attributesMap, List<LinkData> list, int n2, long l2) {
        this.context = spanContext;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.parentSpanContext = spanContext2;
        this.links = list;
        this.totalRecordedLinks = n2;
        this.name = string;
        this.kind = spanKind;
        this.spanProcessor = spanProcessor;
        this.resource = resource;
        this.hasEnded = false;
        this.clock = anchoredClock;
        this.startEpochNanos = l2;
        this.attributes = attributesMap;
        this.events = new ArrayList<EventData>();
        this.spanLimits = spanLimits;
    }

    static SdkSpan startSpan(SpanContext spanContext, String string, InstrumentationScopeInfo instrumentationScopeInfo, SpanKind spanKind, Span span, Context context, SpanLimits spanLimits, SpanProcessor spanProcessor, Clock clock, Resource resource, @Nullable AttributesMap attributesMap, List<LinkData> list, int n2, long l2) {
        boolean bl2;
        AnchoredClock anchoredClock;
        if (span instanceof SdkSpan) {
            SdkSpan sdkSpan = (SdkSpan)span;
            anchoredClock = sdkSpan.clock;
            bl2 = false;
        } else {
            anchoredClock = AnchoredClock.create(clock);
            bl2 = true;
        }
        long l3 = l2 != 0L ? l2 : (bl2 ? anchoredClock.startTime() : anchoredClock.now());
        SdkSpan sdkSpan = new SdkSpan(spanContext, string, instrumentationScopeInfo, spanKind, span.getSpanContext(), spanLimits, spanProcessor, anchoredClock, resource, attributesMap, list, n2, l3);
        spanProcessor.onStart(context, sdkSpan);
        return sdkSpan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpanData toSpanData() {
        Object object = this.lock;
        synchronized (object) {
            return SpanWrapper.create(this, this.links, this.getImmutableTimedEvents(), this.getImmutableAttributes(), this.attributes == null ? 0 : this.attributes.getTotalAddedValues(), this.totalRecordedEvents, this.status, this.name, this.endEpochNanos, this.hasEnded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <T> T getAttribute(AttributeKey<T> attributeKey) {
        Object object = this.lock;
        synchronized (object) {
            return this.attributes == null ? null : (T)this.attributes.get(attributeKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasEnded() {
        Object object = this.lock;
        synchronized (object) {
            return this.hasEnded;
        }
    }

    @Override
    public SpanContext getSpanContext() {
        return this.context;
    }

    @Override
    public SpanContext getParentSpanContext() {
        return this.parentSpanContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() {
        Object object = this.lock;
        synchronized (object) {
            return this.name;
        }
    }

    @Override
    @Deprecated
    public InstrumentationLibraryInfo getInstrumentationLibraryInfo() {
        return InstrumentationScopeUtil.toInstrumentationLibraryInfo(this.getInstrumentationScopeInfo());
    }

    @Override
    public InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLatencyNanos() {
        Object object = this.lock;
        synchronized (object) {
            return (this.hasEnded ? this.endEpochNanos : this.clock.now()) - this.startEpochNanos;
        }
    }

    AnchoredClock getClock() {
        return this.clock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> ReadWriteSpan setAttribute(AttributeKey<T> attributeKey, T t2) {
        if (attributeKey == null || attributeKey.getKey().isEmpty() || t2 == null) {
            return this;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.hasEnded) {
                logger.a(f.a.f, "Calling setAttribute() on an ended Span.");
                return this;
            }
            if (this.attributes == null) {
                this.attributes = AttributesMap.create(this.spanLimits.getMaxNumberOfAttributes(), this.spanLimits.getMaxAttributeValueLength());
            }
            this.attributes.put(attributeKey, t2);
        }
        return this;
    }

    @Override
    public ReadWriteSpan addEvent(String string) {
        if (string == null) {
            return this;
        }
        this.addTimedEvent(EventData.create(this.clock.now(), string, Attributes.empty(), 0));
        return this;
    }

    @Override
    public ReadWriteSpan addEvent(String string, long l2, TimeUnit timeUnit) {
        if (string == null || timeUnit == null) {
            return this;
        }
        this.addTimedEvent(EventData.create(timeUnit.toNanos(l2), string, Attributes.empty(), 0));
        return this;
    }

    @Override
    public ReadWriteSpan addEvent(String string, Attributes attributes) {
        if (string == null) {
            return this;
        }
        if (attributes == null) {
            attributes = Attributes.empty();
        }
        int n2 = attributes.size();
        this.addTimedEvent(EventData.create(this.clock.now(), string, AttributeUtil.applyAttributesLimit(attributes, this.spanLimits.getMaxNumberOfAttributesPerEvent(), this.spanLimits.getMaxAttributeValueLength()), n2));
        return this;
    }

    @Override
    public ReadWriteSpan addEvent(String string, Attributes attributes, long l2, TimeUnit timeUnit) {
        if (string == null || timeUnit == null) {
            return this;
        }
        if (attributes == null) {
            attributes = Attributes.empty();
        }
        int n2 = attributes.size();
        this.addTimedEvent(EventData.create(timeUnit.toNanos(l2), string, AttributeUtil.applyAttributesLimit(attributes, this.spanLimits.getMaxNumberOfAttributesPerEvent(), this.spanLimits.getMaxAttributeValueLength()), n2));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTimedEvent(EventData eventData) {
        Object object = this.lock;
        synchronized (object) {
            if (this.hasEnded) {
                logger.a(f.a.f, "Calling addEvent() on an ended Span.");
                return;
            }
            if (this.events.size() < this.spanLimits.getMaxNumberOfEvents()) {
                this.events.add(eventData);
            }
            ++this.totalRecordedEvents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadWriteSpan setStatus(StatusCode statusCode, @Nullable String string) {
        if (statusCode == null) {
            return this;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.hasEnded) {
                logger.a(f.a.f, "Calling setStatus() on an ended Span.");
                return this;
            }
            this.status = StatusData.create(statusCode, string);
        }
        return this;
    }

    @Override
    public ReadWriteSpan recordException(Throwable throwable) {
        this.recordException(throwable, Attributes.empty());
        return this;
    }

    @Override
    public ReadWriteSpan recordException(Throwable throwable, Attributes attributes) {
        if (throwable == null) {
            return this;
        }
        if (attributes == null) {
            attributes = Attributes.empty();
        }
        this.addTimedEvent(ExceptionEventData.create(this.spanLimits, this.clock.now(), throwable, attributes));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadWriteSpan updateName(String string) {
        if (string == null) {
            return this;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.hasEnded) {
                logger.a(f.a.f, "Calling updateName() on an ended Span.");
                return this;
            }
            this.name = string;
        }
        return this;
    }

    @Override
    public void end() {
        this.endInternal(this.clock.now());
    }

    @Override
    public void end(long l2, TimeUnit timeUnit) {
        if (timeUnit == null) {
            timeUnit = TimeUnit.NANOSECONDS;
        }
        this.endInternal(l2 == 0L ? this.clock.now() : timeUnit.toNanos(l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endInternal(long l2) {
        Object object = this.lock;
        synchronized (object) {
            if (this.hasEnded) {
                logger.a(f.a.f, "Calling end() on an ended Span.");
                return;
            }
            this.endEpochNanos = l2;
            this.hasEnded = true;
        }
        this.spanProcessor.onEnd(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRecording() {
        Object object = this.lock;
        synchronized (object) {
            return !this.hasEnded;
        }
    }

    Resource getResource() {
        return this.resource;
    }

    @Override
    public SpanKind getKind() {
        return this.kind;
    }

    long getStartEpochNanos() {
        return this.startEpochNanos;
    }

    int getTotalRecordedLinks() {
        return this.totalRecordedLinks;
    }

    private List<EventData> getImmutableTimedEvents() {
        if (this.events.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.hasEnded) {
            return Collections.unmodifiableList(this.events);
        }
        return Collections.unmodifiableList(new ArrayList<EventData>(this.events));
    }

    private Attributes getImmutableAttributes() {
        if (this.attributes == null || this.attributes.isEmpty()) {
            return Attributes.empty();
        }
        if (this.hasEnded) {
            return this.attributes;
        }
        return this.attributes.immutableCopy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        long l2;
        long l3;
        String string;
        String string2;
        String string3;
        Object object = this.lock;
        synchronized (object) {
            string3 = this.name;
            string2 = String.valueOf(this.attributes);
            string = String.valueOf(this.status);
            l3 = this.totalRecordedEvents;
            l2 = this.endEpochNanos;
        }
        return "SdkSpan{traceId=" + this.context.getTraceId() + ", spanId=" + this.context.getSpanId() + ", parentSpanContext=" + this.parentSpanContext + ", name=" + string3 + ", kind=" + (Object)((Object)this.kind) + ", attributes=" + string2 + ", status=" + string + ", totalRecordedEvents=" + l3 + ", totalRecordedLinks=" + this.totalRecordedLinks + ", startEpochNanos=" + this.startEpochNanos + ", endEpochNanos=" + l2 + "}";
    }
}

