/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.export;

import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.CompletableResultCode;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.data.SpanData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.export.MultiSpanExporter;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.export.NoopSpanExporter;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public interface SpanExporter
extends Closeable {
    public static SpanExporter composite(SpanExporter ... spanExporterArray) {
        return SpanExporter.composite(Arrays.asList(spanExporterArray));
    }

    public static SpanExporter composite(Iterable<SpanExporter> iterable) {
        ArrayList<SpanExporter> arrayList = new ArrayList<SpanExporter>();
        for (SpanExporter spanExporter : iterable) {
            arrayList.add(spanExporter);
        }
        if (arrayList.isEmpty()) {
            return NoopSpanExporter.getInstance();
        }
        if (arrayList.size() == 1) {
            return (SpanExporter)arrayList.get(0);
        }
        return MultiSpanExporter.create(arrayList);
    }

    public CompletableResultCode export(Collection<SpanData> var1);

    public CompletableResultCode flush();

    public CompletableResultCode shutdown();

    @Override
    default public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }
}

