/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.samplers;

import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.Attributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.internal.OtelEncodingUtils;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.SpanKind;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.Context;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.data.LinkData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.samplers.Sampler;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.samplers.SamplingResult;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
final class TraceIdRatioBasedSampler
implements Sampler {
    private static final SamplingResult POSITIVE_SAMPLING_RESULT = SamplingResult.recordAndSample();
    private static final SamplingResult NEGATIVE_SAMPLING_RESULT = SamplingResult.drop();
    private final long idUpperBound;
    private final String description;

    static TraceIdRatioBasedSampler create(double d2) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("ratio must be in range [0.0, 1.0]");
        }
        long l2 = d2 == 0.0 ? Long.MIN_VALUE : (d2 == 1.0 ? Long.MAX_VALUE : (long)(d2 * 9.223372036854776E18));
        return new TraceIdRatioBasedSampler(d2, l2);
    }

    TraceIdRatioBasedSampler(double d2, long l2) {
        this.idUpperBound = l2;
        this.description = "TraceIdRatioBased{" + TraceIdRatioBasedSampler.decimalFormat(d2) + "}";
    }

    @Override
    public SamplingResult shouldSample(Context context, String string, String string2, SpanKind spanKind, Attributes attributes, List<LinkData> list) {
        return Math.abs(TraceIdRatioBasedSampler.getTraceIdRandomPart(string)) < this.idUpperBound ? POSITIVE_SAMPLING_RESULT : NEGATIVE_SAMPLING_RESULT;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof TraceIdRatioBasedSampler)) {
            return false;
        }
        TraceIdRatioBasedSampler traceIdRatioBasedSampler = (TraceIdRatioBasedSampler)object;
        return this.idUpperBound == traceIdRatioBasedSampler.idUpperBound;
    }

    public int hashCode() {
        return Long.hashCode(this.idUpperBound);
    }

    public String toString() {
        return this.getDescription();
    }

    long getIdUpperBound() {
        return this.idUpperBound;
    }

    private static long getTraceIdRandomPart(String string) {
        return OtelEncodingUtils.longFromBase16String(string, 16);
    }

    private static String decimalFormat(double d2) {
        DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance();
        decimalFormatSymbols.setDecimalSeparator('.');
        DecimalFormat decimalFormat = new DecimalFormat("0.000000", decimalFormatSymbols);
        return decimalFormat.format(d2);
    }
}

