/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.net.n3.nanoxml;

import com.contrastsecurity.thirdparty.net.n3.nanoxml.IXMLEntityResolver;
import com.contrastsecurity.thirdparty.net.n3.nanoxml.IXMLReader;
import com.contrastsecurity.thirdparty.net.n3.nanoxml.XMLParseException;
import com.contrastsecurity.thirdparty.net.n3.nanoxml.XMLValidationException;
import java.io.IOException;
import java.io.Reader;

class XMLUtil {
    XMLUtil() {
    }

    static void skipComment(IXMLReader iXMLReader) throws IOException, XMLParseException {
        if (iXMLReader.read() != '-') {
            XMLUtil.errorExpectedInput(iXMLReader.getSystemID(), iXMLReader.getLineNr(), "<!--");
        }
        int n2 = 0;
        block4: while (true) {
            char c2 = iXMLReader.read();
            switch (c2) {
                case '-': {
                    ++n2;
                    continue block4;
                }
                case '>': {
                    if (n2 != 2) break;
                    return;
                }
            }
            n2 = 0;
        }
    }

    static void skipTag(IXMLReader iXMLReader) throws IOException, XMLParseException {
        int n2 = 1;
        while (n2 > 0) {
            char c2 = iXMLReader.read();
            switch (c2) {
                case '<': {
                    ++n2;
                    break;
                }
                case '>': {
                    --n2;
                }
            }
        }
    }

    static String scanPublicID(StringBuffer stringBuffer, IXMLReader iXMLReader) throws IOException, XMLParseException {
        if (!XMLUtil.checkLiteral(iXMLReader, "UBLIC")) {
            return null;
        }
        XMLUtil.skipWhitespace(iXMLReader, null);
        stringBuffer.append(XMLUtil.scanString(iXMLReader, '\u0000', null));
        XMLUtil.skipWhitespace(iXMLReader, null);
        return XMLUtil.scanString(iXMLReader, '\u0000', null);
    }

    static String scanSystemID(IXMLReader iXMLReader) throws IOException, XMLParseException {
        if (!XMLUtil.checkLiteral(iXMLReader, "YSTEM")) {
            return null;
        }
        XMLUtil.skipWhitespace(iXMLReader, null);
        return XMLUtil.scanString(iXMLReader, '\u0000', null);
    }

    static String scanIdentifier(IXMLReader iXMLReader) throws IOException, XMLParseException {
        char c2;
        StringBuffer stringBuffer = new StringBuffer();
        while ((c2 = iXMLReader.read()) == '_' || c2 == ':' || c2 == '-' || c2 == '.' || c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 > '~') {
            stringBuffer.append(c2);
        }
        iXMLReader.unread(c2);
        return stringBuffer.toString();
    }

    static String scanString(IXMLReader iXMLReader, char c2, IXMLEntityResolver iXMLEntityResolver) throws IOException, XMLParseException {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = iXMLReader.getStreamLevel();
        char c3 = iXMLReader.read();
        if (c3 != '\'' && c3 != '\"') {
            XMLUtil.errorExpectedInput(iXMLReader.getSystemID(), iXMLReader.getLineNr(), "delimited string");
        }
        while (true) {
            String string;
            char c4;
            if ((c4 = (string = XMLUtil.read(iXMLReader, c2)).charAt(0)) == c2) {
                if (string.charAt(1) == '#') {
                    stringBuffer.append(XMLUtil.processCharLiteral(string));
                    continue;
                }
                XMLUtil.processEntity(string, iXMLReader, iXMLEntityResolver);
                continue;
            }
            if (c4 == '&') {
                iXMLReader.unread(c4);
                string = XMLUtil.read(iXMLReader, '&');
                if (string.charAt(1) == '#') {
                    stringBuffer.append(XMLUtil.processCharLiteral(string));
                    continue;
                }
                stringBuffer.append(string);
                continue;
            }
            if (iXMLReader.getStreamLevel() == n2) {
                if (c4 == c3) break;
                if (c4 == '\t' || c4 == '\n' || c4 == '\r') {
                    stringBuffer.append(' ');
                    continue;
                }
                stringBuffer.append(c4);
                continue;
            }
            stringBuffer.append(c4);
        }
        return stringBuffer.toString();
    }

    static void processEntity(String string, IXMLReader iXMLReader, IXMLEntityResolver iXMLEntityResolver) throws IOException, XMLParseException {
        boolean bl2;
        Reader reader = iXMLEntityResolver.getEntity(iXMLReader, string = string.substring(1, string.length() - 1));
        if (reader == null) {
            XMLUtil.errorInvalidEntity(iXMLReader.getSystemID(), iXMLReader.getLineNr(), string);
        }
        iXMLReader.startNewStream(reader, !(bl2 = iXMLEntityResolver.isExternalEntity(string)));
    }

    static char processCharLiteral(String string) throws IOException, XMLParseException {
        if (string.charAt(2) == 'x') {
            string = string.substring(3, string.length() - 1);
            return (char)Integer.parseInt(string, 16);
        }
        string = string.substring(2, string.length() - 1);
        return (char)Integer.parseInt(string, 10);
    }

    static void skipWhitespace(IXMLReader iXMLReader, StringBuffer stringBuffer) throws IOException {
        char c2;
        if (stringBuffer == null) {
            while ((c2 = iXMLReader.read()) == ' ' || c2 == '\t' || c2 == '\n') {
            }
        } else {
            while ((c2 = iXMLReader.read()) == ' ' || c2 == '\t' || c2 == '\n') {
                if (c2 == '\n') {
                    stringBuffer.append('\n');
                    continue;
                }
                stringBuffer.append(' ');
            }
        }
        iXMLReader.unread(c2);
    }

    static String read(IXMLReader iXMLReader, char c2) throws IOException, XMLParseException {
        char c3 = iXMLReader.read();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(c3);
        if (c3 == c2) {
            while (c3 != ';') {
                c3 = iXMLReader.read();
                stringBuffer.append(c3);
            }
        }
        return stringBuffer.toString();
    }

    static char readChar(IXMLReader iXMLReader, char c2) throws IOException, XMLParseException {
        String string = XMLUtil.read(iXMLReader, c2);
        char c3 = string.charAt(0);
        if (c3 == c2) {
            XMLUtil.errorUnexpectedEntity(iXMLReader.getSystemID(), iXMLReader.getLineNr(), string);
        }
        return c3;
    }

    static boolean checkLiteral(IXMLReader iXMLReader, String string) throws IOException, XMLParseException {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (iXMLReader.read() == string.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    static void errorExpectedInput(String string, int n2, String string2) throws XMLParseException {
        throw new XMLParseException(string, n2, "Expected: " + string2);
    }

    static void errorInvalidEntity(String string, int n2, String string2) throws XMLParseException {
        throw new XMLParseException(string, n2, "Invalid entity: `&" + string2 + ";'");
    }

    static void errorUnexpectedEntity(String string, int n2, String string2) throws XMLParseException {
        throw new XMLParseException(string, n2, "No entity reference is expected here (" + string2 + ")");
    }

    static void errorUnexpectedCDATA(String string, int n2) throws XMLParseException {
        throw new XMLParseException(string, n2, "No CDATA section is expected here");
    }

    static void errorInvalidInput(String string, int n2, String string2) throws XMLParseException {
        throw new XMLParseException(string, n2, "Invalid input: " + string2);
    }

    static void errorWrongClosingTag(String string, int n2, String string2, String string3) throws XMLParseException {
        throw new XMLParseException(string, n2, "Closing tag does not match opening tag: `" + string3 + "' != `" + string2 + "'");
    }

    static void errorClosingTagNotEmpty(String string, int n2) throws XMLParseException {
        throw new XMLParseException(string, n2, "Closing tag must be empty");
    }

    static void errorMissingElement(String string, int n2, String string2, String string3) throws XMLValidationException {
        throw new XMLValidationException(1, string, n2, string3, null, null, "Element " + string2 + " expects to have a " + string3);
    }

    static void errorUnexpectedElement(String string, int n2, String string2, String string3) throws XMLValidationException {
        throw new XMLValidationException(2, string, n2, string3, null, null, "Unexpected " + string3 + " in a " + string2);
    }

    static void errorMissingAttribute(String string, int n2, String string2, String string3) throws XMLValidationException {
        throw new XMLValidationException(3, string, n2, string2, string3, null, "Element " + string2 + " expects an attribute named " + string3);
    }

    static void errorUnexpectedAttribute(String string, int n2, String string2, String string3) throws XMLValidationException {
        throw new XMLValidationException(4, string, n2, string2, string3, null, "Element " + string2 + " did not expect an attribute named " + string3);
    }

    static void errorInvalidAttributeValue(String string, int n2, String string2, String string3, String string4) throws XMLValidationException {
        throw new XMLValidationException(5, string, n2, string2, string3, string4, "Invalid value for attribute " + string3);
    }

    static void errorMissingPCData(String string, int n2, String string2) throws XMLValidationException {
        throw new XMLValidationException(6, string, n2, null, null, null, "Missing #PCDATA in element " + string2);
    }

    static void errorUnexpectedPCData(String string, int n2, String string2) throws XMLValidationException {
        throw new XMLValidationException(7, string, n2, null, null, null, "Unexpected #PCDATA in element " + string2);
    }

    static void validationError(String string, int n2, String string2, String string3, String string4, String string5) throws XMLValidationException {
        throw new XMLValidationException(0, string, n2, string3, string4, string5, string2);
    }
}

