/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.relational;

import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.Expression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.ExpressionVisitor;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.relational.ItemsList;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.relational.SupportsOldOracleJoinSyntax;

public class InExpression
implements Expression,
SupportsOldOracleJoinSyntax {
    private Expression leftExpression;
    private ItemsList leftItemsList;
    private ItemsList rightItemsList;
    private boolean not = false;
    private int oldOracleJoinSyntax = 0;

    public InExpression() {
    }

    public InExpression(Expression expression, ItemsList itemsList) {
        this.setLeftExpression(expression);
        this.setRightItemsList(itemsList);
    }

    @Override
    public void setOldOracleJoinSyntax(int n2) {
        this.oldOracleJoinSyntax = n2;
        if (n2 < 0 || n2 > 1) {
            throw new IllegalArgumentException("unexpected join type for oracle found with IN (type=" + n2 + ")");
        }
    }

    @Override
    public int getOldOracleJoinSyntax() {
        return this.oldOracleJoinSyntax;
    }

    public ItemsList getRightItemsList() {
        return this.rightItemsList;
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }

    public final void setRightItemsList(ItemsList itemsList) {
        this.rightItemsList = itemsList;
    }

    public final void setLeftExpression(Expression expression) {
        this.leftExpression = expression;
    }

    public boolean isNot() {
        return this.not;
    }

    public void setNot(boolean bl2) {
        this.not = bl2;
    }

    public ItemsList getLeftItemsList() {
        return this.leftItemsList;
    }

    public void setLeftItemsList(ItemsList itemsList) {
        this.leftItemsList = itemsList;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    private String getLeftExpressionString() {
        return this.leftExpression + (this.oldOracleJoinSyntax == 1 ? "(+)" : "");
    }

    public String toString() {
        return (this.leftExpression == null ? this.leftItemsList : this.getLeftExpressionString()) + " " + (this.not ? "NOT " : "") + "IN " + this.rightItemsList + "";
    }

    @Override
    public int getOraclePriorPosition() {
        return 0;
    }

    @Override
    public void setOraclePriorPosition(int n2) {
        if (n2 != 0) {
            throw new IllegalArgumentException("unexpected prior for oracle found");
        }
    }
}

