/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.replace;

import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.Expression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.relational.ItemsList;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.schema.Column;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.schema.Table;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.Statement;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.StatementVisitor;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.PlainSelect;
import java.util.List;

public class Replace
implements Statement {
    private Table table;
    private List<Column> columns;
    private ItemsList itemsList;
    private List<Expression> expressions;
    private boolean useValues = true;
    private boolean useIntoTables = false;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public boolean isUseIntoTables() {
        return this.useIntoTables;
    }

    public void setUseIntoTables(boolean bl2) {
        this.useIntoTables = bl2;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public ItemsList getItemsList() {
        return this.itemsList;
    }

    public void setColumns(List<Column> list) {
        this.columns = list;
    }

    public void setItemsList(ItemsList itemsList) {
        this.itemsList = itemsList;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(List<Expression> list) {
        this.expressions = list;
    }

    public boolean isUseValues() {
        return this.useValues;
    }

    public void setUseValues(boolean bl2) {
        this.useValues = bl2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("REPLACE ");
        if (this.isUseIntoTables()) {
            stringBuilder.append("INTO ");
        }
        stringBuilder.append(this.table);
        if (this.expressions != null && this.columns != null) {
            stringBuilder.append(" SET ");
            int n2 = this.columns.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuilder.append(this.columns.get(i2)).append("=").append(this.expressions.get(i2));
                stringBuilder.append(i2 < n2 - 1 ? ", " : "");
            }
        } else if (this.columns != null) {
            stringBuilder.append(" ").append(PlainSelect.getStringList(this.columns, true, true));
        }
        if (this.itemsList != null) {
            if (this.useValues) {
                stringBuilder.append(" VALUES");
            }
            stringBuilder.append(" ").append(this.itemsList);
        }
        return stringBuilder.toString();
    }
}

