/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.upsert;

import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.Expression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.relational.ItemsList;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.schema.Column;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.schema.Table;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.Statement;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.StatementVisitor;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.PlainSelect;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.Select;
import java.util.List;

public class Upsert
implements Statement {
    private Table table;
    private List<Column> columns;
    private ItemsList itemsList;
    private boolean useValues = true;
    private Select select;
    private boolean useSelectBrackets = true;
    private boolean useDuplicate = false;
    private List<Column> duplicateUpdateColumns;
    private List<Expression> duplicateUpdateExpressionList;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public Table getTable() {
        return this.table;
    }

    public void setColumns(List<Column> list) {
        this.columns = list;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setItemsList(ItemsList itemsList) {
        this.itemsList = itemsList;
    }

    public ItemsList getItemsList() {
        return this.itemsList;
    }

    public void setUseValues(boolean bl2) {
        this.useValues = bl2;
    }

    public boolean isUseValues() {
        return this.useValues;
    }

    public void setSelect(Select select) {
        this.select = select;
    }

    public Select getSelect() {
        return this.select;
    }

    public void setUseSelectBrackets(boolean bl2) {
        this.useSelectBrackets = bl2;
    }

    public boolean isUseSelectBrackets() {
        return this.useSelectBrackets;
    }

    public void setUseDuplicate(boolean bl2) {
        this.useDuplicate = bl2;
    }

    public boolean isUseDuplicate() {
        return this.useDuplicate;
    }

    public void setDuplicateUpdateColumns(List<Column> list) {
        this.duplicateUpdateColumns = list;
    }

    public List<Column> getDuplicateUpdateColumns() {
        return this.duplicateUpdateColumns;
    }

    public void setDuplicateUpdateExpressionList(List<Expression> list) {
        this.duplicateUpdateExpressionList = list;
    }

    public List<Expression> getDuplicateUpdateExpressionList() {
        return this.duplicateUpdateExpressionList;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UPSERT INTO ");
        stringBuilder.append(this.table).append(" ");
        if (this.columns != null) {
            stringBuilder.append(PlainSelect.getStringList(this.columns, true, true)).append(" ");
        }
        if (this.useValues) {
            stringBuilder.append("VALUES ");
        }
        if (this.itemsList != null) {
            stringBuilder.append(this.itemsList);
        } else {
            if (this.useSelectBrackets) {
                stringBuilder.append("(");
            }
            if (this.select != null) {
                stringBuilder.append(this.select);
            }
            if (this.useSelectBrackets) {
                stringBuilder.append(")");
            }
        }
        if (this.useDuplicate) {
            stringBuilder.append(" ON DUPLICATE KEY UPDATE ");
            for (int i2 = 0; i2 < this.getDuplicateUpdateColumns().size(); ++i2) {
                if (i2 != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.duplicateUpdateColumns.get(i2)).append(" = ");
                stringBuilder.append(this.duplicateUpdateExpressionList.get(i2));
            }
        }
        return stringBuilder.toString();
    }
}

