/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.HdrHistogram;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.locks.ReentrantLock;

public class WriterReaderPhaser {
    private volatile long startEpoch = 0L;
    private volatile long evenEndEpoch = 0L;
    private volatile long oddEndEpoch = Long.MIN_VALUE;
    private final ReentrantLock readerLock = new ReentrantLock();
    private static final AtomicLongFieldUpdater<WriterReaderPhaser> startEpochUpdater = AtomicLongFieldUpdater.newUpdater(WriterReaderPhaser.class, "startEpoch");
    private static final AtomicLongFieldUpdater<WriterReaderPhaser> evenEndEpochUpdater = AtomicLongFieldUpdater.newUpdater(WriterReaderPhaser.class, "evenEndEpoch");
    private static final AtomicLongFieldUpdater<WriterReaderPhaser> oddEndEpochUpdater = AtomicLongFieldUpdater.newUpdater(WriterReaderPhaser.class, "oddEndEpoch");

    public long writerCriticalSectionEnter() {
        return startEpochUpdater.getAndIncrement(this);
    }

    public void writerCriticalSectionExit(long l2) {
        (l2 < 0L ? oddEndEpochUpdater : evenEndEpochUpdater).getAndIncrement(this);
    }

    public void readerLock() {
        this.readerLock.lock();
    }

    public void readerUnlock() {
        this.readerLock.unlock();
    }

    public void flipPhase(long l2) {
        if (!this.readerLock.isHeldByCurrentThread()) {
            throw new IllegalStateException("flipPhase() can only be called while holding the readerLock()");
        }
        boolean bl2 = this.startEpoch < 0L;
        long l3 = bl2 ? 0L : Long.MIN_VALUE;
        (bl2 ? evenEndEpochUpdater : oddEndEpochUpdater).lazySet(this, l3);
        long l4 = startEpochUpdater.getAndSet(this, l3);
        while ((bl2 ? this.oddEndEpoch : this.evenEndEpoch) != l4) {
            if (l2 == 0L) {
                Thread.yield();
                continue;
            }
            try {
                TimeUnit.NANOSECONDS.sleep(l2);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void flipPhase() {
        this.flipPhase(0L);
    }
}

