/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.LatencyUtils;

import com.contrastsecurity.agent.scope.GlobalScopeProvider;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.thirdparty.org.LatencyUtils.PauseDetector;
import com.contrastsecurity.thirdparty.org.LatencyUtils.TimeServices;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class SimplePauseDetector
extends PauseDetector {
    private static final long DEFAULT_SleepInterval = 1000000L;
    private static final long DEFAULT_PauseNotificationThreshold = 1000000L;
    private static final int DEFAULT_NumberOfDetectorThreads = 3;
    private static final boolean DEFAULT_Verbose = false;
    private final long sleepInterval;
    private final long pauseNotificationThreshold;
    final AtomicLong consensusLatestTime = new AtomicLong();
    private volatile long stallThreadMask = 0L;
    private volatile long stopThreadMask = 0L;
    private final SimplePauseDetectorThread[] detectors;
    private boolean verbose;

    public SimplePauseDetector(long l2, long l3, int n2) {
        this(l2, l3, n2, false);
    }

    public SimplePauseDetector(long l2, long l3, int n2, boolean bl2) {
        this.sleepInterval = l2;
        this.pauseNotificationThreshold = l3;
        this.verbose = bl2;
        this.detectors = new SimplePauseDetectorThread[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.detectors[i2] = new SimplePauseDetectorThread(i2);
            this.detectors[i2].start();
        }
    }

    public SimplePauseDetector() {
        this(1000000L, 1000000L, 3, false);
    }

    public void setVerbose(boolean bl2) {
        this.verbose = bl2;
    }

    @Override
    public void shutdown() {
        this.stopThreadMask = -1L;
        for (SimplePauseDetectorThread simplePauseDetectorThread : this.detectors) {
            simplePauseDetectorThread.interrupt();
        }
        super.shutdown();
    }

    public void stallDetectorThreads(long l2, long l3) throws InterruptedException {
        long l4 = this.stallThreadMask;
        this.stallThreadMask = l2;
        long l5 = TimeServices.nanoTime();
        long l6 = l5 + l3;
        long l7 = l3;
        while (l7 > 0L) {
            long l8 = Math.min(l7, this.pauseNotificationThreshold / 2L);
            TimeServices.moveTimeForward(l8);
            TimeUnit.NANOSECONDS.sleep(50000L);
            l7 = l6 - TimeServices.nanoTime();
        }
        this.stallThreadMask = l4;
    }

    public void skipConsensusTimeTo(long l2) {
        this.consensusLatestTime.set(l2);
    }

    private class SimplePauseDetectorThread
    extends Thread {
        volatile long observedLasUpdateTime;
        final int threadNumber;
        final long threadMask;

        SimplePauseDetectorThread(int n2) {
            if (n2 < 0 || n2 > 63) {
                throw new IllegalArgumentException("threadNumber must be between 0 and 63.");
            }
            this.threadNumber = n2;
            this.threadMask = 1 << n2;
            this.setDaemon(true);
            this.setName("SimplePauseDetectorThread_" + n2);
        }

        @Override
        public void run() {
            ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
            try {
                long l2;
                long l3 = Long.MAX_VALUE;
                this.observedLasUpdateTime = SimplePauseDetector.this.consensusLatestTime.get();
                long l4 = l2 = TimeServices.nanoTime();
                SimplePauseDetector.this.consensusLatestTime.compareAndSet(this.observedLasUpdateTime, l2);
                while ((SimplePauseDetector.this.stopThreadMask & this.threadMask) == 0L) {
                    if (SimplePauseDetector.this.sleepInterval != 0L) {
                        TimeServices.sleepNanos(SimplePauseDetector.this.sleepInterval);
                    }
                    while ((SimplePauseDetector.this.stallThreadMask & this.threadMask) != 0L) {
                    }
                    this.observedLasUpdateTime = SimplePauseDetector.this.consensusLatestTime.get();
                    l2 = TimeServices.nanoTime();
                    l3 = Math.min(l2 - l4, l3);
                    while (l2 > this.observedLasUpdateTime) {
                        if (SimplePauseDetector.this.consensusLatestTime.compareAndSet(this.observedLasUpdateTime, l2)) {
                            long l5 = l2 - this.observedLasUpdateTime;
                            long l6 = Math.max(l5 - l3, 0L);
                            if (l6 <= SimplePauseDetector.this.pauseNotificationThreshold) continue;
                            if (SimplePauseDetector.this.verbose) {
                                System.out.println("SimplePauseDetector thread " + this.threadNumber + ": sending pause notification message: pause of " + l6 + " nsec detected at nanoTime: " + l2);
                            }
                            SimplePauseDetector.this.notifyListeners(l6, l2);
                            continue;
                        }
                        this.observedLasUpdateTime = SimplePauseDetector.this.consensusLatestTime.get();
                    }
                    l4 = l2;
                }
                if (SimplePauseDetector.this.verbose) {
                    System.out.println("SimplePauseDetector thread " + this.threadNumber + " terminating...");
                }
                scopeAggregator.leaveScope();
                return;
            }
            catch (Throwable throwable) {
                scopeAggregator.leaveScope();
                throw throwable;
            }
        }
    }
}

