/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.codec.binary;

import com.contrastsecurity.thirdparty.org.apache.commons.codec.binary.BaseNCodec;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BaseNCodecOutputStream
extends FilterOutputStream {
    private final boolean doEncode;
    private final BaseNCodec baseNCodec;
    private final byte[] singleByte = new byte[1];
    private final BaseNCodec.Context context = new BaseNCodec.Context();

    public BaseNCodecOutputStream(OutputStream outputStream, BaseNCodec baseNCodec, boolean bl2) {
        super(outputStream);
        this.baseNCodec = baseNCodec;
        this.doEncode = bl2;
    }

    @Override
    public void write(int n2) throws IOException {
        this.singleByte[0] = (byte)n2;
        this.write(this.singleByte, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 > byArray.length || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 > 0) {
            if (this.doEncode) {
                this.baseNCodec.encode(byArray, n2, n3, this.context);
            } else {
                this.baseNCodec.decode(byArray, n2, n3, this.context);
            }
            this.flush(false);
        }
    }

    private void flush(boolean bl2) throws IOException {
        byte[] byArray;
        int n2;
        int n3 = this.baseNCodec.available(this.context);
        if (n3 > 0 && (n2 = this.baseNCodec.readResults(byArray = new byte[n3], 0, n3, this.context)) > 0) {
            this.out.write(byArray, 0, n2);
        }
        if (bl2) {
            this.out.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        this.flush(true);
    }

    @Override
    public void close() throws IOException {
        this.eof();
        this.flush();
        this.out.close();
    }

    public void eof() throws IOException {
        if (this.doEncode) {
            this.baseNCodec.encode(this.singleByte, 0, -1, this.context);
        } else {
            this.baseNCodec.decode(this.singleByte, 0, -1, this.context);
        }
    }
}

