/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.codec.language;

import com.contrastsecurity.thirdparty.org.apache.commons.codec.EncoderException;
import com.contrastsecurity.thirdparty.org.apache.commons.codec.StringEncoder;
import com.contrastsecurity.thirdparty.org.apache.commons.codec.language.SoundexUtils;
import java.util.regex.Pattern;

public class Nysiis
implements StringEncoder {
    private static final char[] CHARS_A = new char[]{'A'};
    private static final char[] CHARS_AF = new char[]{'A', 'F'};
    private static final char[] CHARS_C = new char[]{'C'};
    private static final char[] CHARS_FF = new char[]{'F', 'F'};
    private static final char[] CHARS_G = new char[]{'G'};
    private static final char[] CHARS_N = new char[]{'N'};
    private static final char[] CHARS_NN = new char[]{'N', 'N'};
    private static final char[] CHARS_S = new char[]{'S'};
    private static final char[] CHARS_SSS = new char[]{'S', 'S', 'S'};
    private static final Pattern PAT_MAC = Pattern.compile("^MAC");
    private static final Pattern PAT_KN = Pattern.compile("^KN");
    private static final Pattern PAT_K = Pattern.compile("^K");
    private static final Pattern PAT_PH_PF = Pattern.compile("^(PH|PF)");
    private static final Pattern PAT_SCH = Pattern.compile("^SCH");
    private static final Pattern PAT_EE_IE = Pattern.compile("(EE|IE)$");
    private static final Pattern PAT_DT_ETC = Pattern.compile("(DT|RT|RD|NT|ND)$");
    private static final char SPACE = ' ';
    private static final int TRUE_LENGTH = 6;
    private final boolean strict;

    private static boolean isVowel(char c2) {
        return c2 == 'A' || c2 == 'E' || c2 == 'I' || c2 == 'O' || c2 == 'U';
    }

    private static char[] transcodeRemaining(char c2, char c3, char c4, char c5) {
        if (c3 == 'E' && c4 == 'V') {
            return CHARS_AF;
        }
        if (Nysiis.isVowel(c3)) {
            return CHARS_A;
        }
        if (c3 == 'Q') {
            return CHARS_G;
        }
        if (c3 == 'Z') {
            return CHARS_S;
        }
        if (c3 == 'M') {
            return CHARS_N;
        }
        if (c3 == 'K') {
            if (c4 == 'N') {
                return CHARS_NN;
            }
            return CHARS_C;
        }
        if (c3 == 'S' && c4 == 'C' && c5 == 'H') {
            return CHARS_SSS;
        }
        if (c3 == 'P' && c4 == 'H') {
            return CHARS_FF;
        }
        if (!(c3 != 'H' || Nysiis.isVowel(c2) && Nysiis.isVowel(c4))) {
            return new char[]{c2};
        }
        if (c3 == 'W' && Nysiis.isVowel(c2)) {
            return new char[]{c2};
        }
        return new char[]{c3};
    }

    public Nysiis() {
        this(true);
    }

    public Nysiis(boolean bl2) {
        this.strict = bl2;
    }

    @Override
    public Object encode(Object object) throws EncoderException {
        if (!(object instanceof String)) {
            throw new EncoderException("Parameter supplied to Nysiis encode is not of type java.lang.String");
        }
        return this.nysiis((String)object);
    }

    @Override
    public String encode(String string) {
        return this.nysiis(string);
    }

    public boolean isStrict() {
        return this.strict;
    }

    public String nysiis(String string) {
        char c2;
        int n2;
        if (string == null) {
            return null;
        }
        if ((string = SoundexUtils.clean(string)).length() == 0) {
            return string;
        }
        string = PAT_MAC.matcher(string).replaceFirst("MCC");
        string = PAT_KN.matcher(string).replaceFirst("NN");
        string = PAT_K.matcher(string).replaceFirst("C");
        string = PAT_PH_PF.matcher(string).replaceFirst("FF");
        string = PAT_SCH.matcher(string).replaceFirst("SSS");
        string = PAT_EE_IE.matcher(string).replaceFirst("Y");
        string = PAT_DT_ETC.matcher(string).replaceFirst("D");
        StringBuilder stringBuilder = new StringBuilder(string.length());
        stringBuilder.append(string.charAt(0));
        char[] cArray = string.toCharArray();
        int n3 = cArray.length;
        for (n2 = 1; n2 < n3; ++n2) {
            c2 = n2 < n3 - 1 ? cArray[n2 + 1] : (char)' ';
            char c3 = n2 < n3 - 2 ? cArray[n2 + 2] : (char)' ';
            char[] cArray2 = Nysiis.transcodeRemaining(cArray[n2 - 1], cArray[n2], c2, c3);
            System.arraycopy(cArray2, 0, cArray, n2, cArray2.length);
            if (cArray[n2] == cArray[n2 - 1]) continue;
            stringBuilder.append(cArray[n2]);
        }
        if (stringBuilder.length() > 1) {
            n2 = stringBuilder.charAt(stringBuilder.length() - 1);
            if (n2 == 83) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                n2 = stringBuilder.charAt(stringBuilder.length() - 1);
            }
            if (stringBuilder.length() > 2 && (c2 = stringBuilder.charAt(stringBuilder.length() - 2)) == 'A' && n2 == 89) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 2);
            }
            if (n2 == 65) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
        }
        String string2 = stringBuilder.toString();
        return this.isStrict() ? string2.substring(0, Math.min(6, string2.length())) : string2;
    }
}

