/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.io.filefilter;

import com.contrastsecurity.thirdparty.org.apache.commons.io.IOCase;
import com.contrastsecurity.thirdparty.org.apache.commons.io.filefilter.AbstractFileFilter;
import java.io.File;
import java.io.Serializable;
import java.util.List;

public class NameFileFilter
extends AbstractFileFilter
implements Serializable {
    private static final long serialVersionUID = 176844364689077340L;
    private final String[] names;
    private final IOCase caseSensitivity;

    public NameFileFilter(String string) {
        this(string, null);
    }

    public NameFileFilter(String string, IOCase iOCase) {
        if (string == null) {
            throw new IllegalArgumentException("The wildcard must not be null");
        }
        this.names = new String[]{string};
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    public NameFileFilter(String[] stringArray) {
        this(stringArray, null);
    }

    public NameFileFilter(String[] stringArray, IOCase iOCase) {
        if (stringArray == null) {
            throw new IllegalArgumentException("The array of names must not be null");
        }
        this.names = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.names, 0, stringArray.length);
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    public NameFileFilter(List<String> list) {
        this(list, null);
    }

    public NameFileFilter(List<String> list, IOCase iOCase) {
        if (list == null) {
            throw new IllegalArgumentException("The list of names must not be null");
        }
        this.names = list.toArray(new String[list.size()]);
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    @Override
    public boolean accept(File file) {
        String string = file.getName();
        for (String string2 : this.names) {
            if (!this.caseSensitivity.checkEquals(string, string2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(File file, String string) {
        for (String string2 : this.names) {
            if (!this.caseSensitivity.checkEquals(string, string2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("(");
        if (this.names != null) {
            for (int i2 = 0; i2 < this.names.length; ++i2) {
                if (i2 > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(this.names[i2]);
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

