/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.io.input;

import java.io.IOException;
import java.io.Reader;

public class BoundedReader
extends Reader {
    private static final int INVALID = -1;
    private final Reader target;
    private int charsRead = 0;
    private int markedAt = -1;
    private int readAheadLimit;
    private final int maxCharsFromTargetReader;

    public BoundedReader(Reader reader, int n2) throws IOException {
        this.target = reader;
        this.maxCharsFromTargetReader = n2;
    }

    @Override
    public void close() throws IOException {
        this.target.close();
    }

    @Override
    public void reset() throws IOException {
        this.charsRead = this.markedAt;
        this.target.reset();
    }

    @Override
    public void mark(int n2) throws IOException {
        this.readAheadLimit = n2 - this.charsRead;
        this.markedAt = this.charsRead;
        this.target.mark(n2);
    }

    @Override
    public int read() throws IOException {
        if (this.charsRead >= this.maxCharsFromTargetReader) {
            return -1;
        }
        if (this.markedAt >= 0 && this.charsRead - this.markedAt >= this.readAheadLimit) {
            return -1;
        }
        ++this.charsRead;
        return this.target.read();
    }

    @Override
    public int read(char[] cArray, int n2, int n3) throws IOException {
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = this.read();
            if (n4 == -1) {
                return i2;
            }
            cArray[n2 + i2] = (char)n4;
        }
        return n3;
    }
}

