/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.io.input;

import com.contrastsecurity.thirdparty.org.apache.commons.io.Charsets;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public class ReversedLinesFileReader
implements Closeable {
    private final int blockSize;
    private final Charset encoding;
    private final RandomAccessFile randomAccessFile;
    private final long totalByteLength;
    private final long totalBlockCount;
    private final byte[][] newLineSequences;
    private final int avoidNewlineSplitBufferSize;
    private final int byteDecrement;
    private FilePart currentFilePart;
    private boolean trailingNewlineOfFileSkipped = false;

    @Deprecated
    public ReversedLinesFileReader(File file) throws IOException {
        this(file, 4096, Charset.defaultCharset());
    }

    public ReversedLinesFileReader(File file, Charset charset) throws IOException {
        this(file, 4096, charset);
    }

    public ReversedLinesFileReader(File file, int n2, Charset charset) throws IOException {
        this.blockSize = n2;
        this.encoding = charset;
        Charset charset2 = Charsets.toCharset(charset);
        CharsetEncoder charsetEncoder = charset2.newEncoder();
        float f2 = charsetEncoder.maxBytesPerChar();
        if (f2 == 1.0f) {
            this.byteDecrement = 1;
        } else if (charset2 == Charsets.UTF_8) {
            this.byteDecrement = 1;
        } else if (charset2 == Charset.forName("Shift_JIS") || charset2 == Charset.forName("windows-31j") || charset2 == Charset.forName("x-windows-949") || charset2 == Charset.forName("gbk") || charset2 == Charset.forName("x-windows-950")) {
            this.byteDecrement = 1;
        } else if (charset2 == Charsets.UTF_16BE || charset2 == Charsets.UTF_16LE) {
            this.byteDecrement = 2;
        } else {
            if (charset2 == Charsets.UTF_16) {
                throw new UnsupportedEncodingException("For UTF-16, you need to specify the byte order (use UTF-16BE or UTF-16LE)");
            }
            throw new UnsupportedEncodingException("Encoding " + charset + " is not supported yet (feel free to " + "submit a patch)");
        }
        this.newLineSequences = new byte[][]{"\r\n".getBytes(charset), "\n".getBytes(charset), "\r".getBytes(charset)};
        this.avoidNewlineSplitBufferSize = this.newLineSequences[0].length;
        this.randomAccessFile = new RandomAccessFile(file, "r");
        this.totalByteLength = this.randomAccessFile.length();
        int n3 = (int)(this.totalByteLength % (long)n2);
        if (n3 > 0) {
            this.totalBlockCount = this.totalByteLength / (long)n2 + 1L;
        } else {
            this.totalBlockCount = this.totalByteLength / (long)n2;
            if (this.totalByteLength > 0L) {
                n3 = n2;
            }
        }
        this.currentFilePart = new FilePart(this.totalBlockCount, n3, null);
    }

    public ReversedLinesFileReader(File file, int n2, String string) throws IOException {
        this(file, n2, Charsets.toCharset(string));
    }

    public String readLine() throws IOException {
        String string = this.currentFilePart.readLine();
        while (string == null) {
            this.currentFilePart = this.currentFilePart.rollOver();
            if (this.currentFilePart == null) break;
            string = this.currentFilePart.readLine();
        }
        if ("".equals(string) && !this.trailingNewlineOfFileSkipped) {
            this.trailingNewlineOfFileSkipped = true;
            string = this.readLine();
        }
        return string;
    }

    @Override
    public void close() throws IOException {
        this.randomAccessFile.close();
    }

    private class FilePart {
        private final long no;
        private final byte[] data;
        private byte[] leftOver;
        private int currentLastBytePos;

        private FilePart(long l2, int n2, byte[] byArray) throws IOException {
            this.no = l2;
            int n3 = n2 + (byArray != null ? byArray.length : 0);
            this.data = new byte[n3];
            long l3 = (l2 - 1L) * (long)ReversedLinesFileReader.this.blockSize;
            if (l2 > 0L) {
                ReversedLinesFileReader.this.randomAccessFile.seek(l3);
                int n4 = ReversedLinesFileReader.this.randomAccessFile.read(this.data, 0, n2);
                if (n4 != n2) {
                    throw new IllegalStateException("Count of requested bytes and actually read bytes don't match");
                }
            }
            if (byArray != null) {
                System.arraycopy(byArray, 0, this.data, n2, byArray.length);
            }
            this.currentLastBytePos = this.data.length - 1;
            this.leftOver = null;
        }

        private FilePart rollOver() throws IOException {
            if (this.currentLastBytePos > -1) {
                throw new IllegalStateException("Current currentLastCharPos unexpectedly positive... last readLine() should have returned something! currentLastCharPos=" + this.currentLastBytePos);
            }
            if (this.no > 1L) {
                return new FilePart(this.no - 1L, ReversedLinesFileReader.this.blockSize, this.leftOver);
            }
            if (this.leftOver != null) {
                throw new IllegalStateException("Unexpected leftover of the last block: leftOverOfThisFilePart=" + new String(this.leftOver, ReversedLinesFileReader.this.encoding));
            }
            return null;
        }

        private String readLine() throws IOException {
            String string = null;
            boolean bl2 = this.no == 1L;
            int n2 = this.currentLastBytePos;
            while (n2 > -1) {
                if (!bl2 && n2 < ReversedLinesFileReader.this.avoidNewlineSplitBufferSize) {
                    this.createLeftOver();
                    break;
                }
                int n3 = this.getNewLineMatchByteCount(this.data, n2);
                if (n3 > 0) {
                    int n4 = n2 + 1;
                    int n5 = this.currentLastBytePos - n4 + 1;
                    if (n5 < 0) {
                        throw new IllegalStateException("Unexpected negative line length=" + n5);
                    }
                    byte[] byArray = new byte[n5];
                    System.arraycopy(this.data, n4, byArray, 0, n5);
                    string = new String(byArray, ReversedLinesFileReader.this.encoding);
                    this.currentLastBytePos = n2 - n3;
                    break;
                }
                if ((n2 -= ReversedLinesFileReader.this.byteDecrement) >= 0) continue;
                this.createLeftOver();
                break;
            }
            if (bl2 && this.leftOver != null) {
                string = new String(this.leftOver, ReversedLinesFileReader.this.encoding);
                this.leftOver = null;
            }
            return string;
        }

        private void createLeftOver() {
            int n2 = this.currentLastBytePos + 1;
            if (n2 > 0) {
                this.leftOver = new byte[n2];
                System.arraycopy(this.data, 0, this.leftOver, 0, n2);
            } else {
                this.leftOver = null;
            }
            this.currentLastBytePos = -1;
        }

        private int getNewLineMatchByteCount(byte[] byArray, int n2) {
            for (byte[] byArray2 : ReversedLinesFileReader.this.newLineSequences) {
                boolean bl2 = true;
                for (int i2 = byArray2.length - 1; i2 >= 0; --i2) {
                    int n3 = n2 + i2 - (byArray2.length - 1);
                    bl2 &= n3 >= 0 && byArray[n3] == byArray2[i2];
                }
                if (!bl2) continue;
                return byArray2.length;
            }
            return 0;
        }
    }
}

