/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.io.output;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class ChunkedWriter
extends FilterWriter {
    private static final int DEFAULT_CHUNK_SIZE = 4096;
    private final int chunkSize;

    public ChunkedWriter(Writer writer, int n2) {
        super(writer);
        if (n2 <= 0) {
            throw new IllegalArgumentException();
        }
        this.chunkSize = n2;
    }

    public ChunkedWriter(Writer writer) {
        this(writer, 4096);
    }

    @Override
    public void write(char[] cArray, int n2, int n3) throws IOException {
        int n4 = n3;
        int n5 = n2;
        while (n4 > 0) {
            int n6 = Math.min(n4, this.chunkSize);
            this.out.write(cArray, n5, n6);
            n4 -= n6;
            n5 += n6;
        }
    }
}

