/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.lang;

import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;

public class CharUtils {
    private static final String CHAR_STRING = "\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u007f";
    private static final String[] CHAR_STRING_ARRAY = new String[128];
    private static final Character[] CHAR_ARRAY = new Character[128];
    public static final char LF = '\n';
    public static final char CR = '\r';

    public static Character toCharacterObject(char c2) {
        if (c2 < CHAR_ARRAY.length) {
            return CHAR_ARRAY[c2];
        }
        return new Character(c2);
    }

    public static Character toCharacterObject(String string) {
        if (StringUtils.isEmpty(string)) {
            return null;
        }
        return CharUtils.toCharacterObject(string.charAt(0));
    }

    public static char toChar(Character c2) {
        if (c2 == null) {
            throw new IllegalArgumentException("The Character must not be null");
        }
        return c2.charValue();
    }

    public static char toChar(Character c2, char c3) {
        if (c2 == null) {
            return c3;
        }
        return c2.charValue();
    }

    public static char toChar(String string) {
        if (StringUtils.isEmpty(string)) {
            throw new IllegalArgumentException("The String must not be empty");
        }
        return string.charAt(0);
    }

    public static char toChar(String string, char c2) {
        if (StringUtils.isEmpty(string)) {
            return c2;
        }
        return string.charAt(0);
    }

    public static int toIntValue(char c2) {
        if (!CharUtils.isAsciiNumeric(c2)) {
            throw new IllegalArgumentException("The character " + c2 + " is not in the range '0' - '9'");
        }
        return c2 - 48;
    }

    public static int toIntValue(char c2, int n2) {
        if (!CharUtils.isAsciiNumeric(c2)) {
            return n2;
        }
        return c2 - 48;
    }

    public static int toIntValue(Character c2) {
        if (c2 == null) {
            throw new IllegalArgumentException("The character must not be null");
        }
        return CharUtils.toIntValue(c2.charValue());
    }

    public static int toIntValue(Character c2, int n2) {
        if (c2 == null) {
            return n2;
        }
        return CharUtils.toIntValue(c2.charValue(), n2);
    }

    public static String toString(char c2) {
        if (c2 < '\u0080') {
            return CHAR_STRING_ARRAY[c2];
        }
        return new String(new char[]{c2});
    }

    public static String toString(Character c2) {
        if (c2 == null) {
            return null;
        }
        return CharUtils.toString(c2.charValue());
    }

    public static String unicodeEscaped(char c2) {
        if (c2 < '\u0010') {
            return "\\u000" + Integer.toHexString(c2);
        }
        if (c2 < '\u0100') {
            return "\\u00" + Integer.toHexString(c2);
        }
        if (c2 < '\u1000') {
            return "\\u0" + Integer.toHexString(c2);
        }
        return "\\u" + Integer.toHexString(c2);
    }

    public static String unicodeEscaped(Character c2) {
        if (c2 == null) {
            return null;
        }
        return CharUtils.unicodeEscaped(c2.charValue());
    }

    public static boolean isAscii(char c2) {
        return c2 < '\u0080';
    }

    public static boolean isAsciiPrintable(char c2) {
        return c2 >= ' ' && c2 < '\u007f';
    }

    public static boolean isAsciiControl(char c2) {
        return c2 < ' ' || c2 == '\u007f';
    }

    public static boolean isAsciiAlpha(char c2) {
        return c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z';
    }

    public static boolean isAsciiAlphaUpper(char c2) {
        return c2 >= 'A' && c2 <= 'Z';
    }

    public static boolean isAsciiAlphaLower(char c2) {
        return c2 >= 'a' && c2 <= 'z';
    }

    public static boolean isAsciiNumeric(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    public static boolean isAsciiAlphanumeric(char c2) {
        return c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 >= '0' && c2 <= '9';
    }

    static boolean isHighSurrogate(char c2) {
        return '\ud800' <= c2 && '\udbff' >= c2;
    }

    static {
        for (int i2 = 127; i2 >= 0; --i2) {
            CharUtils.CHAR_STRING_ARRAY[i2] = CHAR_STRING.substring(i2, i2 + 1);
            CharUtils.CHAR_ARRAY[i2] = new Character((char)i2);
        }
    }
}

