/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.lang;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.ArrayUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.NullArgumentException;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.text.StrBuilder;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ClassUtils {
    public static final char PACKAGE_SEPARATOR_CHAR = '.';
    public static final String PACKAGE_SEPARATOR = String.valueOf('.');
    public static final char INNER_CLASS_SEPARATOR_CHAR = '$';
    public static final String INNER_CLASS_SEPARATOR = String.valueOf('$');
    private static final Map primitiveWrapperMap = new HashMap();
    private static final Map wrapperPrimitiveMap;
    private static final Map abbreviationMap;
    private static final Map reverseAbbreviationMap;
    static Class class$java$lang$Boolean;
    static Class class$java$lang$Byte;
    static Class class$java$lang$Character;
    static Class class$java$lang$Short;
    static Class class$java$lang$Integer;
    static Class class$java$lang$Long;
    static Class class$java$lang$Double;
    static Class class$java$lang$Float;
    static Class class$org$apache$commons$lang$ClassUtils;

    private static void addAbbreviation(String string, String string2) {
        abbreviationMap.put(string, string2);
        reverseAbbreviationMap.put(string2, string);
    }

    public static String getShortClassName(Object object, String string) {
        if (object == null) {
            return string;
        }
        return ClassUtils.getShortClassName(object.getClass());
    }

    public static String getShortClassName(Class clazz) {
        if (clazz == null) {
            return "";
        }
        return ClassUtils.getShortClassName(clazz.getName());
    }

    public static String getShortClassName(String string) {
        int n2;
        if (string == null) {
            return "";
        }
        if (string.length() == 0) {
            return "";
        }
        StrBuilder strBuilder = new StrBuilder();
        if (string.startsWith("[")) {
            while (string.charAt(0) == '[') {
                string = string.substring(1);
                strBuilder.append("[]");
            }
            if (string.charAt(0) == 'L' && string.charAt(string.length() - 1) == ';') {
                string = string.substring(1, string.length() - 1);
            }
        }
        if (reverseAbbreviationMap.containsKey(string)) {
            string = (String)reverseAbbreviationMap.get(string);
        }
        int n3 = string.indexOf(36, (n2 = string.lastIndexOf(46)) == -1 ? 0 : n2 + 1);
        String string2 = string.substring(n2 + 1);
        if (n3 != -1) {
            string2 = string2.replace('$', '.');
        }
        return string2 + strBuilder;
    }

    public static String getPackageName(Object object, String string) {
        if (object == null) {
            return string;
        }
        return ClassUtils.getPackageName(object.getClass());
    }

    public static String getPackageName(Class clazz) {
        if (clazz == null) {
            return "";
        }
        return ClassUtils.getPackageName(clazz.getName());
    }

    public static String getPackageName(String string) {
        int n2;
        if (string == null || string.length() == 0) {
            return "";
        }
        while (string.charAt(0) == '[') {
            string = string.substring(1);
        }
        if (string.charAt(0) == 'L' && string.charAt(string.length() - 1) == ';') {
            string = string.substring(1);
        }
        if ((n2 = string.lastIndexOf(46)) == -1) {
            return "";
        }
        return string.substring(0, n2);
    }

    public static List getAllSuperclasses(Class clazz) {
        if (clazz == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        for (Class clazz2 = clazz.getSuperclass(); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            arrayList.add(clazz2);
        }
        return arrayList;
    }

    public static List getAllInterfaces(Class clazz) {
        if (clazz == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        ClassUtils.getAllInterfaces(clazz, arrayList);
        return arrayList;
    }

    private static void getAllInterfaces(Class clazz, List list) {
        while (clazz != null) {
            Class<?>[] classArray = clazz.getInterfaces();
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                if (list.contains(classArray[i2])) continue;
                list.add(classArray[i2]);
                ClassUtils.getAllInterfaces(classArray[i2], list);
            }
            clazz = clazz.getSuperclass();
        }
    }

    public static List convertClassNamesToClasses(List list) {
        if (list == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                arrayList.add(Class.forName(string));
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                Exception exception2 = exception;
                arrayList.add(null);
            }
        }
        return arrayList;
    }

    public static List convertClassesToClassNames(List list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            if (clazz == null) {
                arrayList.add(null);
                continue;
            }
            arrayList.add(clazz.getName());
        }
        return arrayList;
    }

    public static boolean isAssignable(Class[] classArray, Class[] classArray2) {
        return ClassUtils.isAssignable(classArray, classArray2, false);
    }

    public static boolean isAssignable(Class[] classArray, Class[] classArray2, boolean bl2) {
        if (!ArrayUtils.isSameLength(classArray, classArray2)) {
            return false;
        }
        if (classArray == null) {
            classArray = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        if (classArray2 == null) {
            classArray2 = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            if (ClassUtils.isAssignable(classArray[i2], classArray2[i2], bl2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAssignable(Class clazz, Class clazz2) {
        return ClassUtils.isAssignable(clazz, clazz2, false);
    }

    public static boolean isAssignable(Class clazz, Class clazz2, boolean bl2) {
        if (clazz2 == null) {
            return false;
        }
        if (clazz == null) {
            return !clazz2.isPrimitive();
        }
        if (bl2) {
            if (clazz.isPrimitive() && !clazz2.isPrimitive() && (clazz = ClassUtils.primitiveToWrapper(clazz)) == null) {
                return false;
            }
            if (clazz2.isPrimitive() && !clazz.isPrimitive() && (clazz = ClassUtils.wrapperToPrimitive(clazz)) == null) {
                return false;
            }
        }
        if (clazz.equals(clazz2)) {
            return true;
        }
        if (clazz.isPrimitive()) {
            if (!clazz2.isPrimitive()) {
                return false;
            }
            if (Integer.TYPE.equals(clazz)) {
                return Long.TYPE.equals(clazz2) || Float.TYPE.equals(clazz2) || Double.TYPE.equals(clazz2);
            }
            if (Long.TYPE.equals(clazz)) {
                return Float.TYPE.equals(clazz2) || Double.TYPE.equals(clazz2);
            }
            if (Boolean.TYPE.equals(clazz)) {
                return false;
            }
            if (Double.TYPE.equals(clazz)) {
                return false;
            }
            if (Float.TYPE.equals(clazz)) {
                return Double.TYPE.equals(clazz2);
            }
            if (Character.TYPE.equals(clazz)) {
                return Integer.TYPE.equals(clazz2) || Long.TYPE.equals(clazz2) || Float.TYPE.equals(clazz2) || Double.TYPE.equals(clazz2);
            }
            if (Short.TYPE.equals(clazz)) {
                return Integer.TYPE.equals(clazz2) || Long.TYPE.equals(clazz2) || Float.TYPE.equals(clazz2) || Double.TYPE.equals(clazz2);
            }
            if (Byte.TYPE.equals(clazz)) {
                return Short.TYPE.equals(clazz2) || Integer.TYPE.equals(clazz2) || Long.TYPE.equals(clazz2) || Float.TYPE.equals(clazz2) || Double.TYPE.equals(clazz2);
            }
            return false;
        }
        return clazz2.isAssignableFrom(clazz);
    }

    public static Class primitiveToWrapper(Class clazz) {
        Class clazz2 = clazz;
        if (clazz != null && clazz.isPrimitive()) {
            clazz2 = (Class)primitiveWrapperMap.get(clazz);
        }
        return clazz2;
    }

    public static Class[] primitivesToWrappers(Class[] classArray) {
        if (classArray == null) {
            return null;
        }
        if (classArray.length == 0) {
            return classArray;
        }
        Class[] classArray2 = new Class[classArray.length];
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            classArray2[i2] = ClassUtils.primitiveToWrapper(classArray[i2]);
        }
        return classArray2;
    }

    public static Class wrapperToPrimitive(Class clazz) {
        return (Class)wrapperPrimitiveMap.get(clazz);
    }

    public static Class[] wrappersToPrimitives(Class[] classArray) {
        if (classArray == null) {
            return null;
        }
        if (classArray.length == 0) {
            return classArray;
        }
        Class[] classArray2 = new Class[classArray.length];
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            classArray2[i2] = ClassUtils.wrapperToPrimitive(classArray[i2]);
        }
        return classArray2;
    }

    public static boolean isInnerClass(Class clazz) {
        if (clazz == null) {
            return false;
        }
        return clazz.getName().indexOf(36) >= 0;
    }

    public static Class getClass(ClassLoader classLoader, String string, boolean bl2) throws ClassNotFoundException {
        try {
            Class<?> clazz;
            if (abbreviationMap.containsKey(string)) {
                String string2 = "[" + abbreviationMap.get(string);
                clazz = Class.forName(string2, bl2, classLoader).getComponentType();
            } else {
                clazz = Class.forName(ClassUtils.toCanonicalName(string), bl2, classLoader);
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            int n2 = string.lastIndexOf(46);
            if (n2 != -1) {
                try {
                    return ClassUtils.getClass(classLoader, string.substring(0, n2) + '$' + string.substring(n2 + 1), bl2);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    // empty catch block
                }
            }
            throw classNotFoundException;
        }
    }

    public static Class getClass(ClassLoader classLoader, String string) throws ClassNotFoundException {
        return ClassUtils.getClass(classLoader, string, true);
    }

    public static Class getClass(String string) throws ClassNotFoundException {
        return ClassUtils.getClass(string, true);
    }

    public static Class getClass(String string, boolean bl2) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader2 = classLoader == null ? (class$org$apache$commons$lang$ClassUtils == null ? (class$org$apache$commons$lang$ClassUtils = ClassUtils.class$("com.contrastsecurity.thirdparty.org.apache.commons.lang.ClassUtils")) : class$org$apache$commons$lang$ClassUtils).getClassLoader() : classLoader;
        return ClassUtils.getClass(classLoader2, string, bl2);
    }

    public static Method getPublicMethod(Class clazz, String string, Class[] classArray) throws SecurityException, NoSuchMethodException {
        Method method = clazz.getMethod(string, classArray);
        if (Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            return method;
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(ClassUtils.getAllInterfaces(clazz));
        arrayList.addAll(ClassUtils.getAllSuperclasses(clazz));
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Method method2;
            Class clazz2 = (Class)iterator.next();
            if (!Modifier.isPublic(clazz2.getModifiers())) continue;
            try {
                method2 = clazz2.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
            if (!Modifier.isPublic(method2.getDeclaringClass().getModifiers())) continue;
            return method2;
        }
        throw new NoSuchMethodException("Can't find a public method for " + string + " " + ArrayUtils.toString(classArray));
    }

    private static String toCanonicalName(String string) {
        if ((string = StringUtils.deleteWhitespace(string)) == null) {
            throw new NullArgumentException("className");
        }
        if (string.endsWith("[]")) {
            StrBuilder strBuilder = new StrBuilder();
            while (string.endsWith("[]")) {
                string = string.substring(0, string.length() - 2);
                strBuilder.append("[");
            }
            String string2 = (String)abbreviationMap.get(string);
            if (string2 != null) {
                strBuilder.append(string2);
            } else {
                strBuilder.append("L").append(string).append(";");
            }
            string = strBuilder.toString();
        }
        return string;
    }

    public static Class[] toClass(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        if (objectArray.length == 0) {
            return ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        Class[] classArray = new Class[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            classArray[i2] = objectArray[i2] == null ? null : objectArray[i2].getClass();
        }
        return classArray;
    }

    public static String getShortCanonicalName(Object object, String string) {
        if (object == null) {
            return string;
        }
        return ClassUtils.getShortCanonicalName(object.getClass().getName());
    }

    public static String getShortCanonicalName(Class clazz) {
        if (clazz == null) {
            return "";
        }
        return ClassUtils.getShortCanonicalName(clazz.getName());
    }

    public static String getShortCanonicalName(String string) {
        return ClassUtils.getShortClassName(ClassUtils.getCanonicalName(string));
    }

    public static String getPackageCanonicalName(Object object, String string) {
        if (object == null) {
            return string;
        }
        return ClassUtils.getPackageCanonicalName(object.getClass().getName());
    }

    public static String getPackageCanonicalName(Class clazz) {
        if (clazz == null) {
            return "";
        }
        return ClassUtils.getPackageCanonicalName(clazz.getName());
    }

    public static String getPackageCanonicalName(String string) {
        return ClassUtils.getPackageName(ClassUtils.getCanonicalName(string));
    }

    private static String getCanonicalName(String string) {
        if ((string = StringUtils.deleteWhitespace(string)) == null) {
            return null;
        }
        int n2 = 0;
        while (string.startsWith("[")) {
            ++n2;
            string = string.substring(1);
        }
        if (n2 < 1) {
            return string;
        }
        if (string.startsWith("L")) {
            string = string.substring(1, string.endsWith(";") ? string.length() - 1 : string.length());
        } else if (string.length() > 0) {
            string = (String)reverseAbbreviationMap.get(string.substring(0, 1));
        }
        StrBuilder strBuilder = new StrBuilder(string);
        for (int i2 = 0; i2 < n2; ++i2) {
            strBuilder.append("[]");
        }
        return strBuilder.toString();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        primitiveWrapperMap.put(Boolean.TYPE, class$java$lang$Boolean == null ? (class$java$lang$Boolean = ClassUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        primitiveWrapperMap.put(Byte.TYPE, class$java$lang$Byte == null ? (class$java$lang$Byte = ClassUtils.class$("java.lang.Byte")) : class$java$lang$Byte);
        primitiveWrapperMap.put(Character.TYPE, class$java$lang$Character == null ? (class$java$lang$Character = ClassUtils.class$("java.lang.Character")) : class$java$lang$Character);
        primitiveWrapperMap.put(Short.TYPE, class$java$lang$Short == null ? (class$java$lang$Short = ClassUtils.class$("java.lang.Short")) : class$java$lang$Short);
        primitiveWrapperMap.put(Integer.TYPE, class$java$lang$Integer == null ? (class$java$lang$Integer = ClassUtils.class$("java.lang.Integer")) : class$java$lang$Integer);
        primitiveWrapperMap.put(Long.TYPE, class$java$lang$Long == null ? (class$java$lang$Long = ClassUtils.class$("java.lang.Long")) : class$java$lang$Long);
        primitiveWrapperMap.put(Double.TYPE, class$java$lang$Double == null ? (class$java$lang$Double = ClassUtils.class$("java.lang.Double")) : class$java$lang$Double);
        primitiveWrapperMap.put(Float.TYPE, class$java$lang$Float == null ? (class$java$lang$Float = ClassUtils.class$("java.lang.Float")) : class$java$lang$Float);
        primitiveWrapperMap.put(Void.TYPE, Void.TYPE);
        wrapperPrimitiveMap = new HashMap();
        Iterator iterator = primitiveWrapperMap.keySet().iterator();
        while (iterator.hasNext()) {
            Class clazz;
            Class clazz2 = (Class)iterator.next();
            if (clazz2.equals(clazz = (Class)primitiveWrapperMap.get(clazz2))) continue;
            wrapperPrimitiveMap.put(clazz, clazz2);
        }
        abbreviationMap = new HashMap();
        reverseAbbreviationMap = new HashMap();
        ClassUtils.addAbbreviation("int", "I");
        ClassUtils.addAbbreviation("boolean", "Z");
        ClassUtils.addAbbreviation("float", "F");
        ClassUtils.addAbbreviation("long", "J");
        ClassUtils.addAbbreviation("short", "S");
        ClassUtils.addAbbreviation("byte", "B");
        ClassUtils.addAbbreviation("double", "D");
        ClassUtils.addAbbreviation("char", "C");
    }
}

