/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.lang;

class IntHashMap {
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private final float loadFactor;

    public IntHashMap() {
        this(20, 0.75f);
    }

    public IntHashMap(int n2) {
        this(n2, 0.75f);
    }

    public IntHashMap(int n2, float f2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n2);
        }
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load: " + f2);
        }
        if (n2 == 0) {
            n2 = 1;
        }
        this.loadFactor = f2;
        this.table = new Entry[n2];
        this.threshold = (int)((float)n2 * f2);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this.table;
        int n2 = entryArray.length;
        while (n2-- > 0) {
            Entry entry = entryArray[n2];
            while (entry != null) {
                if (entry.value.equals(object)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean containsValue(Object object) {
        return this.contains(object);
    }

    public boolean containsKey(int n2) {
        Entry[] entryArray = this.table;
        int n3 = n2;
        int n4 = (n3 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n4];
        while (entry != null) {
            if (entry.hash == n3) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public Object get(int n2) {
        Entry[] entryArray = this.table;
        int n3 = n2;
        int n4 = (n3 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n4];
        while (entry != null) {
            if (entry.hash == n3) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    protected void rehash() {
        int n2 = this.table.length;
        Entry[] entryArray = this.table;
        int n3 = n2 * 2 + 1;
        Entry[] entryArray2 = new Entry[n3];
        this.threshold = (int)((float)n3 * this.loadFactor);
        this.table = entryArray2;
        int n4 = n2;
        while (n4-- > 0) {
            Entry entry = entryArray[n4];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n5 = (entry2.hash & Integer.MAX_VALUE) % n3;
                entry2.next = entryArray2[n5];
                entryArray2[n5] = entry2;
            }
        }
    }

    public Object put(int n2, Object object) {
        Entry[] entryArray = this.table;
        int n3 = n2;
        int n4 = (n3 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n4];
        while (entry != null) {
            if (entry.hash == n3) {
                Object object2 = entry.value;
                entry.value = object;
                return object2;
            }
            entry = entry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            entryArray = this.table;
            n4 = (n3 & Integer.MAX_VALUE) % entryArray.length;
        }
        entryArray[n4] = entry = new Entry(n3, n2, object, entryArray[n4]);
        ++this.count;
        return null;
    }

    public Object remove(int n2) {
        Entry[] entryArray = this.table;
        int n3 = n2;
        int n4 = (n3 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n4];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.hash == n3) {
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n4] = entry.next;
                }
                --this.count;
                Object object = entry.value;
                entry.value = null;
                return object;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    public synchronized void clear() {
        Entry[] entryArray = this.table;
        int n2 = entryArray.length;
        while (--n2 >= 0) {
            entryArray[n2] = null;
        }
        this.count = 0;
    }

    private static class Entry {
        final int hash;
        final int key;
        Object value;
        Entry next;

        protected Entry(int n2, int n3, Object object, Entry entry) {
            this.hash = n2;
            this.key = n3;
            this.value = object;
            this.next = entry;
        }
    }
}

