/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.lang;

import java.util.Random;

public class RandomStringUtils {
    private static final Random RANDOM = new Random();

    public static String random(int n2) {
        return RandomStringUtils.random(n2, false, false);
    }

    public static String randomAscii(int n2) {
        return RandomStringUtils.random(n2, 32, 127, false, false);
    }

    public static String randomAlphabetic(int n2) {
        return RandomStringUtils.random(n2, true, false);
    }

    public static String randomAlphanumeric(int n2) {
        return RandomStringUtils.random(n2, true, true);
    }

    public static String randomNumeric(int n2) {
        return RandomStringUtils.random(n2, false, true);
    }

    public static String random(int n2, boolean bl2, boolean bl3) {
        return RandomStringUtils.random(n2, 0, 0, bl2, bl3);
    }

    public static String random(int n2, int n3, int n4, boolean bl2, boolean bl3) {
        return RandomStringUtils.random(n2, n3, n4, bl2, bl3, null, RANDOM);
    }

    public static String random(int n2, int n3, int n4, boolean bl2, boolean bl3, char[] cArray) {
        return RandomStringUtils.random(n2, n3, n4, bl2, bl3, cArray, RANDOM);
    }

    public static String random(int n2, int n3, int n4, boolean bl2, boolean bl3, char[] cArray, Random random) {
        if (n2 == 0) {
            return "";
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Requested random string length " + n2 + " is less than 0.");
        }
        if (n3 == 0 && n4 == 0) {
            n4 = 123;
            n3 = 32;
            if (!bl2 && !bl3) {
                n3 = 0;
                n4 = Integer.MAX_VALUE;
            }
        }
        char[] cArray2 = new char[n2];
        int n5 = n4 - n3;
        while (n2-- != 0) {
            char c2 = cArray == null ? (char)(random.nextInt(n5) + n3) : cArray[random.nextInt(n5) + n3];
            if (bl2 && Character.isLetter(c2) || bl3 && Character.isDigit(c2) || !bl2 && !bl3) {
                if (c2 >= '\udc00' && c2 <= '\udfff') {
                    if (n2 == 0) {
                        ++n2;
                        continue;
                    }
                    cArray2[n2] = c2;
                    cArray2[--n2] = (char)(55296 + random.nextInt(128));
                    continue;
                }
                if (c2 >= '\ud800' && c2 <= '\udb7f') {
                    if (n2 == 0) {
                        ++n2;
                        continue;
                    }
                    cArray2[n2] = (char)(56320 + random.nextInt(128));
                    cArray2[--n2] = c2;
                    continue;
                }
                if (c2 >= '\udb80' && c2 <= '\udbff') {
                    ++n2;
                    continue;
                }
                cArray2[n2] = c2;
                continue;
            }
            ++n2;
        }
        return new String(cArray2);
    }

    public static String random(int n2, String string) {
        if (string == null) {
            return RandomStringUtils.random(n2, 0, 0, false, false, null, RANDOM);
        }
        return RandomStringUtils.random(n2, string.toCharArray());
    }

    public static String random(int n2, char[] cArray) {
        if (cArray == null) {
            return RandomStringUtils.random(n2, 0, 0, false, false, null, RANDOM);
        }
        return RandomStringUtils.random(n2, 0, cArray.length, false, false, cArray, RANDOM);
    }
}

