/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.lang;

import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.SystemUtils;

public class WordUtils {
    public static String wrap(String string, int n2) {
        return WordUtils.wrap(string, n2, null, false);
    }

    public static String wrap(String string, int n2, String string2, boolean bl2) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            string2 = SystemUtils.LINE_SEPARATOR;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        int n3 = string.length();
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer(n3 + 32);
        while (n3 - n4 > n2) {
            if (string.charAt(n4) == ' ') {
                ++n4;
                continue;
            }
            int n5 = string.lastIndexOf(32, n2 + n4);
            if (n5 >= n4) {
                stringBuffer.append(string.substring(n4, n5));
                stringBuffer.append(string2);
                n4 = n5 + 1;
                continue;
            }
            if (bl2) {
                stringBuffer.append(string.substring(n4, n2 + n4));
                stringBuffer.append(string2);
                n4 += n2;
                continue;
            }
            n5 = string.indexOf(32, n2 + n4);
            if (n5 >= 0) {
                stringBuffer.append(string.substring(n4, n5));
                stringBuffer.append(string2);
                n4 = n5 + 1;
                continue;
            }
            stringBuffer.append(string.substring(n4));
            n4 = n3;
        }
        stringBuffer.append(string.substring(n4));
        return stringBuffer.toString();
    }

    public static String capitalize(String string) {
        return WordUtils.capitalize(string, null);
    }

    public static String capitalize(String string, char[] cArray) {
        int n2;
        int n3 = n2 = cArray == null ? -1 : cArray.length;
        if (string == null || string.length() == 0 || n2 == 0) {
            return string;
        }
        int n4 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n4);
        boolean bl2 = true;
        for (int i2 = 0; i2 < n4; ++i2) {
            char c2 = string.charAt(i2);
            if (WordUtils.isDelimiter(c2, cArray)) {
                stringBuffer.append(c2);
                bl2 = true;
                continue;
            }
            if (bl2) {
                stringBuffer.append(Character.toTitleCase(c2));
                bl2 = false;
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static String capitalizeFully(String string) {
        return WordUtils.capitalizeFully(string, null);
    }

    public static String capitalizeFully(String string, char[] cArray) {
        int n2;
        int n3 = n2 = cArray == null ? -1 : cArray.length;
        if (string == null || string.length() == 0 || n2 == 0) {
            return string;
        }
        string = string.toLowerCase();
        return WordUtils.capitalize(string, cArray);
    }

    public static String uncapitalize(String string) {
        return WordUtils.uncapitalize(string, null);
    }

    public static String uncapitalize(String string, char[] cArray) {
        int n2;
        int n3 = n2 = cArray == null ? -1 : cArray.length;
        if (string == null || string.length() == 0 || n2 == 0) {
            return string;
        }
        int n4 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n4);
        boolean bl2 = true;
        for (int i2 = 0; i2 < n4; ++i2) {
            char c2 = string.charAt(i2);
            if (WordUtils.isDelimiter(c2, cArray)) {
                stringBuffer.append(c2);
                bl2 = true;
                continue;
            }
            if (bl2) {
                stringBuffer.append(Character.toLowerCase(c2));
                bl2 = false;
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static String swapCase(String string) {
        int n2;
        if (string == null || (n2 = string.length()) == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        boolean bl2 = true;
        char c2 = '\u0000';
        char c3 = '\u0000';
        for (int i2 = 0; i2 < n2; ++i2) {
            c2 = string.charAt(i2);
            c3 = Character.isUpperCase(c2) ? Character.toLowerCase(c2) : (Character.isTitleCase(c2) ? Character.toLowerCase(c2) : (Character.isLowerCase(c2) ? (bl2 ? Character.toTitleCase(c2) : Character.toUpperCase(c2)) : c2));
            stringBuffer.append(c3);
            bl2 = Character.isWhitespace(c2);
        }
        return stringBuffer.toString();
    }

    public static String initials(String string) {
        return WordUtils.initials(string, null);
    }

    public static String initials(String string, char[] cArray) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (cArray != null && cArray.length == 0) {
            return "";
        }
        int n2 = string.length();
        char[] cArray2 = new char[n2 / 2 + 1];
        int n3 = 0;
        boolean bl2 = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (WordUtils.isDelimiter(c2, cArray)) {
                bl2 = true;
                continue;
            }
            if (!bl2) continue;
            cArray2[n3++] = c2;
            bl2 = false;
        }
        return new String(cArray2, 0, n3);
    }

    private static boolean isDelimiter(char c2, char[] cArray) {
        if (cArray == null) {
            return Character.isWhitespace(c2);
        }
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (c2 != cArray[i2]) continue;
            return true;
        }
        return false;
    }

    public static String abbreviate(String string, int n2, int n3, String string2) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return "";
        }
        if (n2 > string.length()) {
            n2 = string.length();
        }
        if (n3 == -1 || n3 > string.length()) {
            n3 = string.length();
        }
        if (n3 < n2) {
            n3 = n2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = StringUtils.indexOf(string, " ", n2);
        if (n4 == -1) {
            stringBuffer.append(string.substring(0, n3));
            if (n3 != string.length()) {
                stringBuffer.append(StringUtils.defaultString(string2));
            }
        } else if (n4 > n3) {
            stringBuffer.append(string.substring(0, n3));
            stringBuffer.append(StringUtils.defaultString(string2));
        } else {
            stringBuffer.append(string.substring(0, n4));
            stringBuffer.append(StringUtils.defaultString(string2));
        }
        return stringBuffer.toString();
    }
}

