/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.lang.math;

import com.contrastsecurity.thirdparty.org.apache.commons.lang.math.Range;
import java.io.Serializable;

public final class FloatRange
extends Range
implements Serializable {
    private static final long serialVersionUID = 71849363892750L;
    private final float min;
    private final float max;
    private transient Float minObject = null;
    private transient Float maxObject = null;
    private transient int hashCode = 0;
    private transient String toString = null;

    public FloatRange(float f2) {
        if (Float.isNaN(f2)) {
            throw new IllegalArgumentException("The number must not be NaN");
        }
        this.min = f2;
        this.max = f2;
    }

    public FloatRange(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("The number must not be null");
        }
        this.min = number.floatValue();
        this.max = number.floatValue();
        if (Float.isNaN(this.min) || Float.isNaN(this.max)) {
            throw new IllegalArgumentException("The number must not be NaN");
        }
        if (number instanceof Float) {
            this.minObject = (Float)number;
            this.maxObject = (Float)number;
        }
    }

    public FloatRange(float f2, float f3) {
        if (Float.isNaN(f2) || Float.isNaN(f3)) {
            throw new IllegalArgumentException("The numbers must not be NaN");
        }
        if (f3 < f2) {
            this.min = f3;
            this.max = f2;
        } else {
            this.min = f2;
            this.max = f3;
        }
    }

    public FloatRange(Number number, Number number2) {
        if (number == null || number2 == null) {
            throw new IllegalArgumentException("The numbers must not be null");
        }
        float f2 = number.floatValue();
        float f3 = number2.floatValue();
        if (Float.isNaN(f2) || Float.isNaN(f3)) {
            throw new IllegalArgumentException("The numbers must not be NaN");
        }
        if (f3 < f2) {
            this.min = f3;
            this.max = f2;
            if (number2 instanceof Float) {
                this.minObject = (Float)number2;
            }
            if (number instanceof Float) {
                this.maxObject = (Float)number;
            }
        } else {
            this.min = f2;
            this.max = f3;
            if (number instanceof Float) {
                this.minObject = (Float)number;
            }
            if (number2 instanceof Float) {
                this.maxObject = (Float)number2;
            }
        }
    }

    public Number getMinimumNumber() {
        if (this.minObject == null) {
            this.minObject = new Float(this.min);
        }
        return this.minObject;
    }

    public long getMinimumLong() {
        return (long)this.min;
    }

    public int getMinimumInteger() {
        return (int)this.min;
    }

    public double getMinimumDouble() {
        return this.min;
    }

    public float getMinimumFloat() {
        return this.min;
    }

    public Number getMaximumNumber() {
        if (this.maxObject == null) {
            this.maxObject = new Float(this.max);
        }
        return this.maxObject;
    }

    public long getMaximumLong() {
        return (long)this.max;
    }

    public int getMaximumInteger() {
        return (int)this.max;
    }

    public double getMaximumDouble() {
        return this.max;
    }

    public float getMaximumFloat() {
        return this.max;
    }

    public boolean containsNumber(Number number) {
        if (number == null) {
            return false;
        }
        return this.containsFloat(number.floatValue());
    }

    public boolean containsFloat(float f2) {
        return f2 >= this.min && f2 <= this.max;
    }

    public boolean containsRange(Range range) {
        if (range == null) {
            return false;
        }
        return this.containsFloat(range.getMinimumFloat()) && this.containsFloat(range.getMaximumFloat());
    }

    public boolean overlapsRange(Range range) {
        if (range == null) {
            return false;
        }
        return range.containsFloat(this.min) || range.containsFloat(this.max) || this.containsFloat(range.getMinimumFloat());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FloatRange)) {
            return false;
        }
        FloatRange floatRange = (FloatRange)object;
        return Float.floatToIntBits(this.min) == Float.floatToIntBits(floatRange.min) && Float.floatToIntBits(this.max) == Float.floatToIntBits(floatRange.max);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 17;
            this.hashCode = 37 * this.hashCode + this.getClass().hashCode();
            this.hashCode = 37 * this.hashCode + Float.floatToIntBits(this.min);
            this.hashCode = 37 * this.hashCode + Float.floatToIntBits(this.max);
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.toString == null) {
            StringBuffer stringBuffer = new StringBuffer(32);
            stringBuffer.append("Range[");
            stringBuffer.append(this.min);
            stringBuffer.append(',');
            stringBuffer.append(this.max);
            stringBuffer.append(']');
            this.toString = stringBuffer.toString();
        }
        return this.toString;
    }
}

