/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.lang.math;

import com.contrastsecurity.thirdparty.org.apache.commons.lang.math.Range;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.text.StrBuilder;
import java.io.Serializable;

public final class IntRange
extends Range
implements Serializable {
    private static final long serialVersionUID = 71849363892730L;
    private final int min;
    private final int max;
    private transient Integer minObject = null;
    private transient Integer maxObject = null;
    private transient int hashCode = 0;
    private transient String toString = null;

    public IntRange(int n2) {
        this.min = n2;
        this.max = n2;
    }

    public IntRange(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("The number must not be null");
        }
        this.min = number.intValue();
        this.max = number.intValue();
        if (number instanceof Integer) {
            this.minObject = (Integer)number;
            this.maxObject = (Integer)number;
        }
    }

    public IntRange(int n2, int n3) {
        if (n3 < n2) {
            this.min = n3;
            this.max = n2;
        } else {
            this.min = n2;
            this.max = n3;
        }
    }

    public IntRange(Number number, Number number2) {
        if (number == null || number2 == null) {
            throw new IllegalArgumentException("The numbers must not be null");
        }
        int n2 = number.intValue();
        int n3 = number2.intValue();
        if (n3 < n2) {
            this.min = n3;
            this.max = n2;
            if (number2 instanceof Integer) {
                this.minObject = (Integer)number2;
            }
            if (number instanceof Integer) {
                this.maxObject = (Integer)number;
            }
        } else {
            this.min = n2;
            this.max = n3;
            if (number instanceof Integer) {
                this.minObject = (Integer)number;
            }
            if (number2 instanceof Integer) {
                this.maxObject = (Integer)number2;
            }
        }
    }

    public Number getMinimumNumber() {
        if (this.minObject == null) {
            this.minObject = new Integer(this.min);
        }
        return this.minObject;
    }

    public long getMinimumLong() {
        return this.min;
    }

    public int getMinimumInteger() {
        return this.min;
    }

    public double getMinimumDouble() {
        return this.min;
    }

    public float getMinimumFloat() {
        return this.min;
    }

    public Number getMaximumNumber() {
        if (this.maxObject == null) {
            this.maxObject = new Integer(this.max);
        }
        return this.maxObject;
    }

    public long getMaximumLong() {
        return this.max;
    }

    public int getMaximumInteger() {
        return this.max;
    }

    public double getMaximumDouble() {
        return this.max;
    }

    public float getMaximumFloat() {
        return this.max;
    }

    public boolean containsNumber(Number number) {
        if (number == null) {
            return false;
        }
        return this.containsInteger(number.intValue());
    }

    public boolean containsInteger(int n2) {
        return n2 >= this.min && n2 <= this.max;
    }

    public boolean containsRange(Range range) {
        if (range == null) {
            return false;
        }
        return this.containsInteger(range.getMinimumInteger()) && this.containsInteger(range.getMaximumInteger());
    }

    public boolean overlapsRange(Range range) {
        if (range == null) {
            return false;
        }
        return range.containsInteger(this.min) || range.containsInteger(this.max) || this.containsInteger(range.getMinimumInteger());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntRange)) {
            return false;
        }
        IntRange intRange = (IntRange)object;
        return this.min == intRange.min && this.max == intRange.max;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 17;
            this.hashCode = 37 * this.hashCode + this.getClass().hashCode();
            this.hashCode = 37 * this.hashCode + this.min;
            this.hashCode = 37 * this.hashCode + this.max;
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.toString == null) {
            StrBuilder strBuilder = new StrBuilder(32);
            strBuilder.append("Range[");
            strBuilder.append(this.min);
            strBuilder.append(',');
            strBuilder.append(this.max);
            strBuilder.append(']');
            this.toString = strBuilder.toString();
        }
        return this.toString;
    }

    public int[] toArray() {
        int[] nArray = new int[this.max - this.min + 1];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = this.min + i2;
        }
        return nArray;
    }
}

