/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.lang.math;

import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberUtils {
    public static final Long LONG_ZERO = new Long(0L);
    public static final Long LONG_ONE = new Long(1L);
    public static final Long LONG_MINUS_ONE = new Long(-1L);
    public static final Integer INTEGER_ZERO = new Integer(0);
    public static final Integer INTEGER_ONE = new Integer(1);
    public static final Integer INTEGER_MINUS_ONE = new Integer(-1);
    public static final Short SHORT_ZERO = new Short(0);
    public static final Short SHORT_ONE = new Short(1);
    public static final Short SHORT_MINUS_ONE = new Short(-1);
    public static final Byte BYTE_ZERO = new Byte(0);
    public static final Byte BYTE_ONE = new Byte(1);
    public static final Byte BYTE_MINUS_ONE = new Byte(-1);
    public static final Double DOUBLE_ZERO = new Double(0.0);
    public static final Double DOUBLE_ONE = new Double(1.0);
    public static final Double DOUBLE_MINUS_ONE = new Double(-1.0);
    public static final Float FLOAT_ZERO = new Float(0.0f);
    public static final Float FLOAT_ONE = new Float(1.0f);
    public static final Float FLOAT_MINUS_ONE = new Float(-1.0f);

    public static int stringToInt(String string) {
        return NumberUtils.toInt(string);
    }

    public static int toInt(String string) {
        return NumberUtils.toInt(string, 0);
    }

    public static int stringToInt(String string, int n2) {
        return NumberUtils.toInt(string, n2);
    }

    public static int toInt(String string, int n2) {
        if (string == null) {
            return n2;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n2;
        }
    }

    public static long toLong(String string) {
        return NumberUtils.toLong(string, 0L);
    }

    public static long toLong(String string, long l2) {
        if (string == null) {
            return l2;
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return l2;
        }
    }

    public static float toFloat(String string) {
        return NumberUtils.toFloat(string, 0.0f);
    }

    public static float toFloat(String string, float f2) {
        if (string == null) {
            return f2;
        }
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            return f2;
        }
    }

    public static double toDouble(String string) {
        return NumberUtils.toDouble(string, 0.0);
    }

    public static double toDouble(String string, double d2) {
        if (string == null) {
            return d2;
        }
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return d2;
        }
    }

    public static byte toByte(String string) {
        return NumberUtils.toByte(string, (byte)0);
    }

    public static byte toByte(String string, byte by2) {
        if (string == null) {
            return by2;
        }
        try {
            return Byte.parseByte(string);
        }
        catch (NumberFormatException numberFormatException) {
            return by2;
        }
    }

    public static short toShort(String string) {
        return NumberUtils.toShort(string, (short)0);
    }

    public static short toShort(String string, short s2) {
        if (string == null) {
            return s2;
        }
        try {
            return Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            return s2;
        }
    }

    public static Number createNumber(String string) throws NumberFormatException {
        Number number;
        String string2;
        String string3;
        if (string == null) {
            return null;
        }
        if (StringUtils.isBlank(string)) {
            throw new NumberFormatException("A blank string is not a valid number");
        }
        if (string.startsWith("--")) {
            return null;
        }
        if (string.startsWith("0x") || string.startsWith("-0x")) {
            return NumberUtils.createInteger(string);
        }
        char c2 = string.charAt(string.length() - 1);
        int n2 = string.indexOf(46);
        int n3 = string.indexOf(101) + string.indexOf(69) + 1;
        if (n2 > -1) {
            if (n3 > -1) {
                if (n3 < n2 || n3 > string.length()) {
                    throw new NumberFormatException(string + " is not a valid number.");
                }
                string3 = string.substring(n2 + 1, n3);
            } else {
                string3 = string.substring(n2 + 1);
            }
            string2 = string.substring(0, n2);
        } else {
            if (n3 > -1) {
                if (n3 > string.length()) {
                    throw new NumberFormatException(string + " is not a valid number.");
                }
                string2 = string.substring(0, n3);
            } else {
                string2 = string;
            }
            string3 = null;
        }
        if (!Character.isDigit(c2) && c2 != '.') {
            String string4 = n3 > -1 && n3 < string.length() - 1 ? string.substring(n3 + 1, string.length() - 1) : null;
            String string5 = string.substring(0, string.length() - 1);
            boolean bl2 = NumberUtils.isAllZeros(string2) && NumberUtils.isAllZeros(string4);
            switch (c2) {
                case 'L': 
                case 'l': {
                    if (string3 == null && string4 == null && (string5.charAt(0) == '-' && NumberUtils.isDigits(string5.substring(1)) || NumberUtils.isDigits(string5))) {
                        try {
                            return NumberUtils.createLong(string5);
                        }
                        catch (NumberFormatException numberFormatException) {
                            return NumberUtils.createBigInteger(string5);
                        }
                    }
                    throw new NumberFormatException(string + " is not a valid number.");
                }
                case 'F': 
                case 'f': {
                    Number number2;
                    try {
                        number2 = NumberUtils.createFloat(string5);
                        if (!((Float)number2).isInfinite() && (((Float)number2).floatValue() != 0.0f || bl2)) {
                            return number2;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                case 'D': 
                case 'd': {
                    Number number2;
                    try {
                        number2 = NumberUtils.createDouble(string5);
                        if (!((Double)number2).isInfinite() && ((double)((Double)number2).floatValue() != 0.0 || bl2)) {
                            return number2;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    try {
                        return NumberUtils.createBigDecimal(string5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            throw new NumberFormatException(string + " is not a valid number.");
        }
        String string6 = n3 > -1 && n3 < string.length() - 1 ? string.substring(n3 + 1, string.length()) : null;
        if (string3 == null && string6 == null) {
            try {
                return NumberUtils.createInteger(string);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return NumberUtils.createLong(string);
                }
                catch (NumberFormatException numberFormatException2) {
                    return NumberUtils.createBigInteger(string);
                }
            }
        }
        boolean bl3 = NumberUtils.isAllZeros(string2) && NumberUtils.isAllZeros(string6);
        try {
            number = NumberUtils.createFloat(string);
            if (!((Float)number).isInfinite() && (((Float)number).floatValue() != 0.0f || bl3)) {
                return number;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            number = NumberUtils.createDouble(string);
            if (!((Double)number).isInfinite() && ((Double)number != 0.0 || bl3)) {
                return number;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return NumberUtils.createBigDecimal(string);
    }

    private static boolean isAllZeros(String string) {
        if (string == null) {
            return true;
        }
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            if (string.charAt(i2) == '0') continue;
            return false;
        }
        return string.length() > 0;
    }

    public static Float createFloat(String string) {
        if (string == null) {
            return null;
        }
        return Float.valueOf(string);
    }

    public static Double createDouble(String string) {
        if (string == null) {
            return null;
        }
        return Double.valueOf(string);
    }

    public static Integer createInteger(String string) {
        if (string == null) {
            return null;
        }
        return Integer.decode(string);
    }

    public static Long createLong(String string) {
        if (string == null) {
            return null;
        }
        return Long.valueOf(string);
    }

    public static BigInteger createBigInteger(String string) {
        if (string == null) {
            return null;
        }
        return new BigInteger(string);
    }

    public static BigDecimal createBigDecimal(String string) {
        if (string == null) {
            return null;
        }
        if (StringUtils.isBlank(string)) {
            throw new NumberFormatException("A blank string is not a valid number");
        }
        return new BigDecimal(string);
    }

    public static long min(long[] lArray) {
        if (lArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (lArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        long l2 = lArray[0];
        for (int i2 = 1; i2 < lArray.length; ++i2) {
            if (lArray[i2] >= l2) continue;
            l2 = lArray[i2];
        }
        return l2;
    }

    public static int min(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (nArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        int n2 = nArray[0];
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            if (nArray[i2] >= n2) continue;
            n2 = nArray[i2];
        }
        return n2;
    }

    public static short min(short[] sArray) {
        if (sArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (sArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        short s2 = sArray[0];
        for (int i2 = 1; i2 < sArray.length; ++i2) {
            if (sArray[i2] >= s2) continue;
            s2 = sArray[i2];
        }
        return s2;
    }

    public static byte min(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        byte by2 = byArray[0];
        for (int i2 = 1; i2 < byArray.length; ++i2) {
            if (byArray[i2] >= by2) continue;
            by2 = byArray[i2];
        }
        return by2;
    }

    public static double min(double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (dArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        double d2 = dArray[0];
        for (int i2 = 1; i2 < dArray.length; ++i2) {
            if (Double.isNaN(dArray[i2])) {
                return Double.NaN;
            }
            if (!(dArray[i2] < d2)) continue;
            d2 = dArray[i2];
        }
        return d2;
    }

    public static float min(float[] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (fArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        float f2 = fArray[0];
        for (int i2 = 1; i2 < fArray.length; ++i2) {
            if (Float.isNaN(fArray[i2])) {
                return Float.NaN;
            }
            if (!(fArray[i2] < f2)) continue;
            f2 = fArray[i2];
        }
        return f2;
    }

    public static long max(long[] lArray) {
        if (lArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (lArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        long l2 = lArray[0];
        for (int i2 = 1; i2 < lArray.length; ++i2) {
            if (lArray[i2] <= l2) continue;
            l2 = lArray[i2];
        }
        return l2;
    }

    public static int max(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (nArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        int n2 = nArray[0];
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            if (nArray[i2] <= n2) continue;
            n2 = nArray[i2];
        }
        return n2;
    }

    public static short max(short[] sArray) {
        if (sArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (sArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        short s2 = sArray[0];
        for (int i2 = 1; i2 < sArray.length; ++i2) {
            if (sArray[i2] <= s2) continue;
            s2 = sArray[i2];
        }
        return s2;
    }

    public static byte max(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        byte by2 = byArray[0];
        for (int i2 = 1; i2 < byArray.length; ++i2) {
            if (byArray[i2] <= by2) continue;
            by2 = byArray[i2];
        }
        return by2;
    }

    public static double max(double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (dArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        double d2 = dArray[0];
        for (int i2 = 1; i2 < dArray.length; ++i2) {
            if (Double.isNaN(dArray[i2])) {
                return Double.NaN;
            }
            if (!(dArray[i2] > d2)) continue;
            d2 = dArray[i2];
        }
        return d2;
    }

    public static float max(float[] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (fArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        float f2 = fArray[0];
        for (int i2 = 1; i2 < fArray.length; ++i2) {
            if (Float.isNaN(fArray[i2])) {
                return Float.NaN;
            }
            if (!(fArray[i2] > f2)) continue;
            f2 = fArray[i2];
        }
        return f2;
    }

    public static long min(long l2, long l3, long l4) {
        if (l3 < l2) {
            l2 = l3;
        }
        if (l4 < l2) {
            l2 = l4;
        }
        return l2;
    }

    public static int min(int n2, int n3, int n4) {
        if (n3 < n2) {
            n2 = n3;
        }
        if (n4 < n2) {
            n2 = n4;
        }
        return n2;
    }

    public static short min(short s2, short s3, short s4) {
        if (s3 < s2) {
            s2 = s3;
        }
        if (s4 < s2) {
            s2 = s4;
        }
        return s2;
    }

    public static byte min(byte by2, byte by3, byte by4) {
        if (by3 < by2) {
            by2 = by3;
        }
        if (by4 < by2) {
            by2 = by4;
        }
        return by2;
    }

    public static double min(double d2, double d3, double d4) {
        return Math.min(Math.min(d2, d3), d4);
    }

    public static float min(float f2, float f3, float f4) {
        return Math.min(Math.min(f2, f3), f4);
    }

    public static long max(long l2, long l3, long l4) {
        if (l3 > l2) {
            l2 = l3;
        }
        if (l4 > l2) {
            l2 = l4;
        }
        return l2;
    }

    public static int max(int n2, int n3, int n4) {
        if (n3 > n2) {
            n2 = n3;
        }
        if (n4 > n2) {
            n2 = n4;
        }
        return n2;
    }

    public static short max(short s2, short s3, short s4) {
        if (s3 > s2) {
            s2 = s3;
        }
        if (s4 > s2) {
            s2 = s4;
        }
        return s2;
    }

    public static byte max(byte by2, byte by3, byte by4) {
        if (by3 > by2) {
            by2 = by3;
        }
        if (by4 > by2) {
            by2 = by4;
        }
        return by2;
    }

    public static double max(double d2, double d3, double d4) {
        return Math.max(Math.max(d2, d3), d4);
    }

    public static float max(float f2, float f3, float f4) {
        return Math.max(Math.max(f2, f3), f4);
    }

    public static int compare(double d2, double d3) {
        long l2;
        if (d2 < d3) {
            return -1;
        }
        if (d2 > d3) {
            return 1;
        }
        long l3 = Double.doubleToLongBits(d2);
        if (l3 == (l2 = Double.doubleToLongBits(d3))) {
            return 0;
        }
        if (l3 < l2) {
            return -1;
        }
        return 1;
    }

    public static int compare(float f2, float f3) {
        int n2;
        if (f2 < f3) {
            return -1;
        }
        if (f2 > f3) {
            return 1;
        }
        int n3 = Float.floatToIntBits(f2);
        if (n3 == (n2 = Float.floatToIntBits(f3))) {
            return 0;
        }
        if (n3 < n2) {
            return -1;
        }
        return 1;
    }

    public static boolean isDigits(String string) {
        if (StringUtils.isEmpty(string)) {
            return false;
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (Character.isDigit(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(String string) {
        int n2;
        int n3;
        if (StringUtils.isEmpty(string)) {
            return false;
        }
        char[] cArray = string.toCharArray();
        int n4 = cArray.length;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n5 = n3 = cArray[0] == '-' ? 1 : 0;
        if (n4 > n3 + 1 && cArray[n3] == '0' && cArray[n3 + 1] == 'x') {
            int n6 = n3 + 2;
            if (n6 == n4) {
                return false;
            }
            while (n6 < cArray.length) {
                if (!(cArray[n6] >= '0' && cArray[n6] <= '9' || cArray[n6] >= 'a' && cArray[n6] <= 'f' || cArray[n6] >= 'A' && cArray[n6] <= 'F')) {
                    return false;
                }
                ++n6;
            }
            return true;
        }
        --n4;
        for (n2 = n3; n2 < n4 || n2 < n4 + 1 && bl4 && !bl5; ++n2) {
            if (cArray[n2] >= '0' && cArray[n2] <= '9') {
                bl5 = true;
                bl4 = false;
                continue;
            }
            if (cArray[n2] == '.') {
                if (bl3 || bl2) {
                    return false;
                }
                bl3 = true;
                continue;
            }
            if (cArray[n2] == 'e' || cArray[n2] == 'E') {
                if (bl2) {
                    return false;
                }
                if (!bl5) {
                    return false;
                }
                bl2 = true;
                bl4 = true;
                continue;
            }
            if (cArray[n2] == '+' || cArray[n2] == '-') {
                if (!bl4) {
                    return false;
                }
                bl4 = false;
                bl5 = false;
                continue;
            }
            return false;
        }
        if (n2 < cArray.length) {
            if (cArray[n2] >= '0' && cArray[n2] <= '9') {
                return true;
            }
            if (cArray[n2] == 'e' || cArray[n2] == 'E') {
                return false;
            }
            if (cArray[n2] == '.') {
                if (bl3 || bl2) {
                    return false;
                }
                return bl5;
            }
            if (!(bl4 || cArray[n2] != 'd' && cArray[n2] != 'D' && cArray[n2] != 'f' && cArray[n2] != 'F')) {
                return bl5;
            }
            if (cArray[n2] == 'l' || cArray[n2] == 'L') {
                return bl5 && !bl2;
            }
            return false;
        }
        return !bl4 && bl5;
    }
}

