/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.lang.text;

import com.contrastsecurity.thirdparty.org.apache.commons.lang.text.StrBuilder;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.text.StrLookup;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.text.StrMatcher;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class StrSubstitutor {
    public static final char DEFAULT_ESCAPE = '$';
    public static final StrMatcher DEFAULT_PREFIX = StrMatcher.stringMatcher("${");
    public static final StrMatcher DEFAULT_SUFFIX = StrMatcher.stringMatcher("}");
    private char escapeChar;
    private StrMatcher prefixMatcher;
    private StrMatcher suffixMatcher;
    private StrLookup variableResolver;
    private boolean enableSubstitutionInVariables;

    public static String replace(Object object, Map map) {
        return new StrSubstitutor(map).replace(object);
    }

    public static String replace(Object object, Map map, String string, String string2) {
        return new StrSubstitutor(map, string, string2).replace(object);
    }

    public static String replace(Object object, Properties properties) {
        if (properties == null) {
            return object.toString();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            hashMap.put(string, string2);
        }
        return StrSubstitutor.replace(object, hashMap);
    }

    public static String replaceSystemProperties(Object object) {
        return new StrSubstitutor(StrLookup.systemPropertiesLookup()).replace(object);
    }

    public StrSubstitutor() {
        this((StrLookup)null, DEFAULT_PREFIX, DEFAULT_SUFFIX, '$');
    }

    public StrSubstitutor(Map map) {
        this(StrLookup.mapLookup(map), DEFAULT_PREFIX, DEFAULT_SUFFIX, '$');
    }

    public StrSubstitutor(Map map, String string, String string2) {
        this(StrLookup.mapLookup(map), string, string2, '$');
    }

    public StrSubstitutor(Map map, String string, String string2, char c2) {
        this(StrLookup.mapLookup(map), string, string2, c2);
    }

    public StrSubstitutor(StrLookup strLookup) {
        this(strLookup, DEFAULT_PREFIX, DEFAULT_SUFFIX, '$');
    }

    public StrSubstitutor(StrLookup strLookup, String string, String string2, char c2) {
        this.setVariableResolver(strLookup);
        this.setVariablePrefix(string);
        this.setVariableSuffix(string2);
        this.setEscapeChar(c2);
    }

    public StrSubstitutor(StrLookup strLookup, StrMatcher strMatcher, StrMatcher strMatcher2, char c2) {
        this.setVariableResolver(strLookup);
        this.setVariablePrefixMatcher(strMatcher);
        this.setVariableSuffixMatcher(strMatcher2);
        this.setEscapeChar(c2);
    }

    public String replace(String string) {
        if (string == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder(string);
        if (!this.substitute(strBuilder, 0, string.length())) {
            return string;
        }
        return strBuilder.toString();
    }

    public String replace(String string, int n2, int n3) {
        if (string == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder(n3).append(string, n2, n3);
        if (!this.substitute(strBuilder, 0, n3)) {
            return string.substring(n2, n2 + n3);
        }
        return strBuilder.toString();
    }

    public String replace(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder(cArray.length).append(cArray);
        this.substitute(strBuilder, 0, cArray.length);
        return strBuilder.toString();
    }

    public String replace(char[] cArray, int n2, int n3) {
        if (cArray == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder(n3).append(cArray, n2, n3);
        this.substitute(strBuilder, 0, n3);
        return strBuilder.toString();
    }

    public String replace(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder(stringBuffer.length()).append(stringBuffer);
        this.substitute(strBuilder, 0, strBuilder.length());
        return strBuilder.toString();
    }

    public String replace(StringBuffer stringBuffer, int n2, int n3) {
        if (stringBuffer == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder(n3).append(stringBuffer, n2, n3);
        this.substitute(strBuilder, 0, n3);
        return strBuilder.toString();
    }

    public String replace(StrBuilder strBuilder) {
        if (strBuilder == null) {
            return null;
        }
        StrBuilder strBuilder2 = new StrBuilder(strBuilder.length()).append(strBuilder);
        this.substitute(strBuilder2, 0, strBuilder2.length());
        return strBuilder2.toString();
    }

    public String replace(StrBuilder strBuilder, int n2, int n3) {
        if (strBuilder == null) {
            return null;
        }
        StrBuilder strBuilder2 = new StrBuilder(n3).append(strBuilder, n2, n3);
        this.substitute(strBuilder2, 0, n3);
        return strBuilder2.toString();
    }

    public String replace(Object object) {
        if (object == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder().append(object);
        this.substitute(strBuilder, 0, strBuilder.length());
        return strBuilder.toString();
    }

    public boolean replaceIn(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return false;
        }
        return this.replaceIn(stringBuffer, 0, stringBuffer.length());
    }

    public boolean replaceIn(StringBuffer stringBuffer, int n2, int n3) {
        if (stringBuffer == null) {
            return false;
        }
        StrBuilder strBuilder = new StrBuilder(n3).append(stringBuffer, n2, n3);
        if (!this.substitute(strBuilder, 0, n3)) {
            return false;
        }
        stringBuffer.replace(n2, n2 + n3, strBuilder.toString());
        return true;
    }

    public boolean replaceIn(StrBuilder strBuilder) {
        if (strBuilder == null) {
            return false;
        }
        return this.substitute(strBuilder, 0, strBuilder.length());
    }

    public boolean replaceIn(StrBuilder strBuilder, int n2, int n3) {
        if (strBuilder == null) {
            return false;
        }
        return this.substitute(strBuilder, n2, n3);
    }

    protected boolean substitute(StrBuilder strBuilder, int n2, int n3) {
        return this.substitute(strBuilder, n2, n3, null) > 0;
    }

    private int substitute(StrBuilder strBuilder, int n2, int n3, List arrayList) {
        StrMatcher strMatcher = this.getVariablePrefixMatcher();
        StrMatcher strMatcher2 = this.getVariableSuffixMatcher();
        char c2 = this.getEscapeChar();
        boolean bl2 = arrayList == null;
        boolean bl3 = false;
        int n4 = 0;
        char[] cArray = strBuilder.buffer;
        int n5 = n2 + n3;
        int n6 = n2;
        block0: while (n6 < n5) {
            int n7 = strMatcher.isMatch(cArray, n6, n2, n5);
            if (n7 == 0) {
                ++n6;
                continue;
            }
            if (n6 > n2 && cArray[n6 - 1] == c2) {
                strBuilder.deleteCharAt(n6 - 1);
                cArray = strBuilder.buffer;
                --n4;
                bl3 = true;
                --n5;
                continue;
            }
            int n8 = n6;
            n6 += n7;
            int n9 = 0;
            int n10 = 0;
            while (n6 < n5) {
                if (this.isEnableSubstitutionInVariables() && (n9 = strMatcher.isMatch(cArray, n6, n2, n5)) != 0) {
                    ++n10;
                    n6 += n9;
                    continue;
                }
                n9 = strMatcher2.isMatch(cArray, n6, n2, n5);
                if (n9 == 0) {
                    ++n6;
                    continue;
                }
                if (n10 == 0) {
                    String string = new String(cArray, n8 + n7, n6 - n8 - n7);
                    if (this.isEnableSubstitutionInVariables()) {
                        StrBuilder strBuilder2 = new StrBuilder(string);
                        this.substitute(strBuilder2, 0, strBuilder2.length());
                        string = strBuilder2.toString();
                    }
                    int n11 = n6 += n9;
                    if (arrayList == null) {
                        arrayList = new ArrayList<String>();
                        arrayList.add(new String(cArray, n2, n3));
                    }
                    this.checkCyclicSubstitution(string, arrayList);
                    arrayList.add(string);
                    String string2 = this.resolveVariable(string, strBuilder, n8, n11);
                    if (string2 != null) {
                        int n12 = string2.length();
                        strBuilder.replace(n8, n11, string2);
                        bl3 = true;
                        int n13 = this.substitute(strBuilder, n8, n12, arrayList);
                        n6 += (n13 += n12 - (n11 - n8));
                        n5 += n13;
                        n4 += n13;
                        cArray = strBuilder.buffer;
                    }
                    arrayList.remove(arrayList.size() - 1);
                    continue block0;
                }
                --n10;
                n6 += n9;
            }
        }
        if (bl2) {
            return bl3 ? 1 : 0;
        }
        return n4;
    }

    private void checkCyclicSubstitution(String string, List list) {
        if (!list.contains(string)) {
            return;
        }
        StrBuilder strBuilder = new StrBuilder(256);
        strBuilder.append("Infinite loop in property interpolation of ");
        strBuilder.append(list.remove(0));
        strBuilder.append(": ");
        strBuilder.appendWithSeparators(list, "->");
        throw new IllegalStateException(strBuilder.toString());
    }

    protected String resolveVariable(String string, StrBuilder strBuilder, int n2, int n3) {
        StrLookup strLookup = this.getVariableResolver();
        if (strLookup == null) {
            return null;
        }
        return strLookup.lookup(string);
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    public void setEscapeChar(char c2) {
        this.escapeChar = c2;
    }

    public StrMatcher getVariablePrefixMatcher() {
        return this.prefixMatcher;
    }

    public StrSubstitutor setVariablePrefixMatcher(StrMatcher strMatcher) {
        if (strMatcher == null) {
            throw new IllegalArgumentException("Variable prefix matcher must not be null!");
        }
        this.prefixMatcher = strMatcher;
        return this;
    }

    public StrSubstitutor setVariablePrefix(char c2) {
        return this.setVariablePrefixMatcher(StrMatcher.charMatcher(c2));
    }

    public StrSubstitutor setVariablePrefix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Variable prefix must not be null!");
        }
        return this.setVariablePrefixMatcher(StrMatcher.stringMatcher(string));
    }

    public StrMatcher getVariableSuffixMatcher() {
        return this.suffixMatcher;
    }

    public StrSubstitutor setVariableSuffixMatcher(StrMatcher strMatcher) {
        if (strMatcher == null) {
            throw new IllegalArgumentException("Variable suffix matcher must not be null!");
        }
        this.suffixMatcher = strMatcher;
        return this;
    }

    public StrSubstitutor setVariableSuffix(char c2) {
        return this.setVariableSuffixMatcher(StrMatcher.charMatcher(c2));
    }

    public StrSubstitutor setVariableSuffix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Variable suffix must not be null!");
        }
        return this.setVariableSuffixMatcher(StrMatcher.stringMatcher(string));
    }

    public StrLookup getVariableResolver() {
        return this.variableResolver;
    }

    public void setVariableResolver(StrLookup strLookup) {
        this.variableResolver = strLookup;
    }

    public boolean isEnableSubstitutionInVariables() {
        return this.enableSubstitutionInVariables;
    }

    public void setEnableSubstitutionInVariables(boolean bl2) {
        this.enableSubstitutionInVariables = bl2;
    }
}

