/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.http.client.protocol;

import com.contrastsecurity.thirdparty.org.apache.http.Header;
import com.contrastsecurity.thirdparty.org.apache.http.HeaderElement;
import com.contrastsecurity.thirdparty.org.apache.http.HttpEntity;
import com.contrastsecurity.thirdparty.org.apache.http.HttpException;
import com.contrastsecurity.thirdparty.org.apache.http.HttpResponse;
import com.contrastsecurity.thirdparty.org.apache.http.HttpResponseInterceptor;
import com.contrastsecurity.thirdparty.org.apache.http.annotation.Contract;
import com.contrastsecurity.thirdparty.org.apache.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.org.apache.http.client.config.RequestConfig;
import com.contrastsecurity.thirdparty.org.apache.http.client.entity.DecompressingEntity;
import com.contrastsecurity.thirdparty.org.apache.http.client.entity.DeflateInputStreamFactory;
import com.contrastsecurity.thirdparty.org.apache.http.client.entity.GZIPInputStreamFactory;
import com.contrastsecurity.thirdparty.org.apache.http.client.entity.InputStreamFactory;
import com.contrastsecurity.thirdparty.org.apache.http.client.protocol.HttpClientContext;
import com.contrastsecurity.thirdparty.org.apache.http.config.Lookup;
import com.contrastsecurity.thirdparty.org.apache.http.config.RegistryBuilder;
import com.contrastsecurity.thirdparty.org.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.util.Locale;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class ResponseContentEncoding
implements HttpResponseInterceptor {
    public static final String UNCOMPRESSED = "http.client.response.uncompressed";
    private final Lookup<InputStreamFactory> decoderRegistry;
    private final boolean ignoreUnknown;

    public ResponseContentEncoding(Lookup<InputStreamFactory> lookup, boolean bl2) {
        this.decoderRegistry = lookup != null ? lookup : RegistryBuilder.create().register("gzip", GZIPInputStreamFactory.getInstance()).register("x-gzip", GZIPInputStreamFactory.getInstance()).register("deflate", (GZIPInputStreamFactory)((Object)DeflateInputStreamFactory.getInstance())).build();
        this.ignoreUnknown = bl2;
    }

    public ResponseContentEncoding(boolean bl2) {
        this(null, bl2);
    }

    public ResponseContentEncoding(Lookup<InputStreamFactory> lookup) {
        this(lookup, true);
    }

    public ResponseContentEncoding() {
        this(null);
    }

    @Override
    public void process(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        Header header;
        HttpEntity httpEntity = httpResponse.getEntity();
        HttpClientContext httpClientContext = HttpClientContext.adapt(httpContext);
        RequestConfig requestConfig = httpClientContext.getRequestConfig();
        if (requestConfig.isContentCompressionEnabled() && httpEntity != null && httpEntity.getContentLength() != 0L && (header = httpEntity.getContentEncoding()) != null) {
            HeaderElement[] headerElementArray;
            for (HeaderElement headerElement : headerElementArray = header.getElements()) {
                String string = headerElement.getName().toLowerCase(Locale.ROOT);
                InputStreamFactory inputStreamFactory = this.decoderRegistry.lookup(string);
                if (inputStreamFactory != null) {
                    httpResponse.setEntity(new DecompressingEntity(httpResponse.getEntity(), inputStreamFactory));
                    httpResponse.removeHeaders("Content-Length");
                    httpResponse.removeHeaders("Content-Encoding");
                    httpResponse.removeHeaders("Content-MD5");
                    continue;
                }
                if ("identity".equals(string) || this.ignoreUnknown) continue;
                throw new HttpException("Unsupported Content-Encoding: " + headerElement.getName());
            }
        }
    }
}

