/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.http.config;

import com.contrastsecurity.thirdparty.org.apache.http.annotation.Contract;
import com.contrastsecurity.thirdparty.org.apache.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class SocketConfig
implements Cloneable {
    public static final SocketConfig DEFAULT = new Builder().build();
    private final int soTimeout;
    private final boolean soReuseAddress;
    private final int soLinger;
    private final boolean soKeepAlive;
    private final boolean tcpNoDelay;
    private final int sndBufSize;
    private final int rcvBufSize;
    private final int backlogSize;

    SocketConfig(int n2, boolean bl2, int n3, boolean bl3, boolean bl4, int n4, int n5, int n6) {
        this.soTimeout = n2;
        this.soReuseAddress = bl2;
        this.soLinger = n3;
        this.soKeepAlive = bl3;
        this.tcpNoDelay = bl4;
        this.sndBufSize = n4;
        this.rcvBufSize = n5;
        this.backlogSize = n6;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public boolean isSoReuseAddress() {
        return this.soReuseAddress;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public boolean isSoKeepAlive() {
        return this.soKeepAlive;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public int getSndBufSize() {
        return this.sndBufSize;
    }

    public int getRcvBufSize() {
        return this.rcvBufSize;
    }

    public int getBacklogSize() {
        return this.backlogSize;
    }

    protected SocketConfig clone() throws CloneNotSupportedException {
        return (SocketConfig)super.clone();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[soTimeout=").append(this.soTimeout).append(", soReuseAddress=").append(this.soReuseAddress).append(", soLinger=").append(this.soLinger).append(", soKeepAlive=").append(this.soKeepAlive).append(", tcpNoDelay=").append(this.tcpNoDelay).append(", sndBufSize=").append(this.sndBufSize).append(", rcvBufSize=").append(this.rcvBufSize).append(", backlogSize=").append(this.backlogSize).append("]");
        return stringBuilder.toString();
    }

    public static Builder custom() {
        return new Builder();
    }

    public static Builder copy(SocketConfig socketConfig) {
        Args.notNull(socketConfig, "Socket config");
        return new Builder().setSoTimeout(socketConfig.getSoTimeout()).setSoReuseAddress(socketConfig.isSoReuseAddress()).setSoLinger(socketConfig.getSoLinger()).setSoKeepAlive(socketConfig.isSoKeepAlive()).setTcpNoDelay(socketConfig.isTcpNoDelay()).setSndBufSize(socketConfig.getSndBufSize()).setRcvBufSize(socketConfig.getRcvBufSize()).setBacklogSize(socketConfig.getBacklogSize());
    }

    public static class Builder {
        private int soTimeout;
        private boolean soReuseAddress;
        private int soLinger = -1;
        private boolean soKeepAlive;
        private boolean tcpNoDelay = true;
        private int sndBufSize;
        private int rcvBufSize;
        private int backlogSize;

        Builder() {
        }

        public Builder setSoTimeout(int n2) {
            this.soTimeout = n2;
            return this;
        }

        public Builder setSoReuseAddress(boolean bl2) {
            this.soReuseAddress = bl2;
            return this;
        }

        public Builder setSoLinger(int n2) {
            this.soLinger = n2;
            return this;
        }

        public Builder setSoKeepAlive(boolean bl2) {
            this.soKeepAlive = bl2;
            return this;
        }

        public Builder setTcpNoDelay(boolean bl2) {
            this.tcpNoDelay = bl2;
            return this;
        }

        public Builder setSndBufSize(int n2) {
            this.sndBufSize = n2;
            return this;
        }

        public Builder setRcvBufSize(int n2) {
            this.rcvBufSize = n2;
            return this;
        }

        public Builder setBacklogSize(int n2) {
            this.backlogSize = n2;
            return this;
        }

        public SocketConfig build() {
            return new SocketConfig(this.soTimeout, this.soReuseAddress, this.soLinger, this.soKeepAlive, this.tcpNoDelay, this.sndBufSize, this.rcvBufSize, this.backlogSize);
        }
    }
}

