/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.http.impl.conn;

import com.contrastsecurity.thirdparty.org.apache.http.HttpHost;
import com.contrastsecurity.thirdparty.org.apache.http.annotation.Contract;
import com.contrastsecurity.thirdparty.org.apache.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.org.apache.http.conn.SchemePortResolver;
import com.contrastsecurity.thirdparty.org.apache.http.conn.UnsupportedSchemeException;
import com.contrastsecurity.thirdparty.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultSchemePortResolver
implements SchemePortResolver {
    public static final DefaultSchemePortResolver INSTANCE = new DefaultSchemePortResolver();

    @Override
    public int resolve(HttpHost httpHost) throws UnsupportedSchemeException {
        Args.notNull(httpHost, "HTTP host");
        int n2 = httpHost.getPort();
        if (n2 > 0) {
            return n2;
        }
        String string = httpHost.getSchemeName();
        if (string.equalsIgnoreCase("http")) {
            return 80;
        }
        if (string.equalsIgnoreCase("https")) {
            return 443;
        }
        throw new UnsupportedSchemeException(string + " protocol is not supported");
    }
}

