/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.Filter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.Layout;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.AbstractAppender;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.AbstractManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.AppenderLoggingException;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.OutputStreamManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Property;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.layout.ByteBufferDestination;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Constants;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;

public abstract class AbstractOutputStreamAppender<M extends OutputStreamManager>
extends AbstractAppender {
    private final boolean immediateFlush;
    private final M manager;

    @Deprecated
    protected AbstractOutputStreamAppender(String string, Layout<? extends Serializable> layout, Filter filter, boolean bl2, boolean bl3, M m2) {
        super(string, filter, layout, bl2, Property.EMPTY_ARRAY);
        this.manager = m2;
        this.immediateFlush = bl3;
    }

    protected AbstractOutputStreamAppender(String string, Layout<? extends Serializable> layout, Filter filter, boolean bl2, boolean bl3, Property[] propertyArray, M m2) {
        super(string, filter, layout, bl2, propertyArray);
        this.manager = m2;
        this.immediateFlush = bl3;
    }

    public boolean getImmediateFlush() {
        return this.immediateFlush;
    }

    public M getManager() {
        return this.manager;
    }

    @Override
    public void start() {
        if (this.getLayout() == null) {
            LOGGER.error("No layout set for the appender named [" + this.getName() + "].");
        }
        if (this.manager == null) {
            LOGGER.error("No OutputStreamManager set for the appender named [" + this.getName() + "].");
        }
        super.start();
    }

    @Override
    public boolean stop(long l2, TimeUnit timeUnit) {
        return this.stop(l2, timeUnit, true);
    }

    @Override
    protected boolean stop(long l2, TimeUnit timeUnit, boolean bl2) {
        boolean bl3 = super.stop(l2, timeUnit, bl2);
        bl3 &= ((AbstractManager)this.manager).stop(l2, timeUnit);
        if (bl2) {
            this.setStopped();
        }
        LOGGER.debug("Appender {} stopped with status {}", (Object)this.getName(), (Object)bl3);
        return bl3;
    }

    @Override
    public void append(LogEvent logEvent) {
        try {
            this.tryAppend(logEvent);
        }
        catch (AppenderLoggingException appenderLoggingException) {
            this.error("Unable to write to stream " + ((AbstractManager)this.manager).getName() + " for appender " + this.getName(), logEvent, appenderLoggingException);
            throw appenderLoggingException;
        }
    }

    private void tryAppend(LogEvent logEvent) {
        if (Constants.ENABLE_DIRECT_ENCODERS) {
            this.directEncodeEvent(logEvent);
        } else {
            this.writeByteArrayToManager(logEvent);
        }
    }

    protected void directEncodeEvent(LogEvent logEvent) {
        this.getLayout().encode(logEvent, (ByteBufferDestination)this.manager);
        if (this.immediateFlush || logEvent.isEndOfBatch()) {
            ((OutputStreamManager)this.manager).flush();
        }
    }

    protected void writeByteArrayToManager(LogEvent logEvent) {
        byte[] byArray = this.getLayout().toByteArray(logEvent);
        if (byArray != null && byArray.length > 0) {
            ((OutputStreamManager)this.manager).write(byArray, this.immediateFlush || logEvent.isEndOfBatch());
        }
    }

    public static abstract class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B> {
        @PluginBuilderAttribute
        private boolean bufferedIo = true;
        @PluginBuilderAttribute
        private int bufferSize = Constants.ENCODER_BYTE_BUFFER_SIZE;
        @PluginBuilderAttribute
        private boolean immediateFlush = true;

        public int getBufferSize() {
            return this.bufferSize;
        }

        public boolean isBufferedIo() {
            return this.bufferedIo;
        }

        public boolean isImmediateFlush() {
            return this.immediateFlush;
        }

        public B setImmediateFlush(boolean bl2) {
            this.immediateFlush = bl2;
            return (B)((Builder)this.asBuilder());
        }

        public B setBufferedIo(boolean bl2) {
            this.bufferedIo = bl2;
            return (B)((Builder)this.asBuilder());
        }

        public B setBufferSize(int n2) {
            this.bufferSize = n2;
            return (B)((Builder)this.asBuilder());
        }

        @Deprecated
        public B withImmediateFlush(boolean bl2) {
            this.immediateFlush = bl2;
            return (B)((Builder)this.asBuilder());
        }

        @Deprecated
        public B withBufferedIo(boolean bl2) {
            this.bufferedIo = bl2;
            return (B)((Builder)this.asBuilder());
        }

        @Deprecated
        public B withBufferSize(int n2) {
            this.bufferSize = n2;
            return (B)((Builder)this.asBuilder());
        }
    }
}

