/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.Filter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.Layout;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.StringLayout;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.AbstractAppender;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.AbstractWriterAppender;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.ManagerFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.WriterManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Property;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.layout.PatternLayout;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.CloseShieldWriter;
import java.io.Serializable;
import java.io.Writer;

@Plugin(name="Writer", category="Core", elementType="appender", printObject=true)
public final class WriterAppender
extends AbstractWriterAppender<WriterManager> {
    private static WriterManagerFactory factory = new WriterManagerFactory();

    @PluginFactory
    public static WriterAppender createAppender(StringLayout stringLayout, Filter filter, Writer writer, String string, boolean bl2, boolean bl3) {
        if (string == null) {
            LOGGER.error("No name provided for WriterAppender");
            return null;
        }
        if (stringLayout == null) {
            stringLayout = PatternLayout.createDefaultLayout();
        }
        return new WriterAppender(string, stringLayout, filter, WriterAppender.getManager(writer, bl2, stringLayout), bl3, null);
    }

    private static WriterManager getManager(Writer writer, boolean bl2, StringLayout stringLayout) {
        CloseShieldWriter closeShieldWriter = new CloseShieldWriter(writer);
        String string = writer.getClass().getName() + "@" + Integer.toHexString(writer.hashCode()) + '.' + bl2;
        return WriterManager.getManager(string, new FactoryData(closeShieldWriter, string, stringLayout), factory);
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    private WriterAppender(String string, StringLayout stringLayout, Filter filter, WriterManager writerManager, boolean bl2, Property[] propertyArray) {
        super(string, stringLayout, filter, bl2, true, propertyArray, writerManager);
    }

    private static class WriterManagerFactory
    implements ManagerFactory<WriterManager, FactoryData> {
        private WriterManagerFactory() {
        }

        @Override
        public WriterManager createManager(String string, FactoryData factoryData) {
            return new WriterManager(factoryData.writer, factoryData.name, factoryData.layout, true);
        }
    }

    private static class FactoryData {
        private final StringLayout layout;
        private final String name;
        private final Writer writer;

        public FactoryData(Writer writer, String string, StringLayout stringLayout) {
            this.writer = writer;
            this.name = string;
            this.layout = stringLayout;
        }
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Builder<WriterAppender> {
        private boolean follow = false;
        private Writer target;

        @Override
        public WriterAppender build() {
            Layout<Serializable> layout = this.getOrCreateLayout();
            if (!(layout instanceof StringLayout)) {
                LOGGER.error("Layout must be a StringLayout to log to ServletContext");
                return null;
            }
            StringLayout stringLayout = (StringLayout)layout;
            return new WriterAppender(this.getName(), stringLayout, this.getFilter(), WriterAppender.getManager(this.target, this.follow, stringLayout), this.isIgnoreExceptions(), this.getPropertyArray());
        }

        public B setFollow(boolean bl2) {
            this.follow = bl2;
            return (B)((Builder)this.asBuilder());
        }

        public B setTarget(Writer writer) {
            this.target = writer;
            return (B)((Builder)this.asBuilder());
        }
    }
}

