/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.mom.kafka;

import com.contrastsecurity.thirdparty.org.apache.kafka.clients.producer.Producer;
import com.contrastsecurity.thirdparty.org.apache.kafka.clients.producer.ProducerRecord;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LoggerContext;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.AbstractManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.ManagerFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.mom.kafka.DefaultKafkaProducerFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.mom.kafka.KafkaProducerFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Property;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Integers;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Log4jThread;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class KafkaManager
extends AbstractManager {
    public static final String DEFAULT_TIMEOUT_MILLIS = "30000";
    static KafkaProducerFactory producerFactory = new DefaultKafkaProducerFactory();
    private final Properties config = new Properties();
    private Producer<byte[], byte[]> producer;
    private final int timeoutMillis;
    private final String topic;
    private final String key;
    private final boolean syncSend;
    private static final KafkaManagerFactory factory = new KafkaManagerFactory();

    public KafkaManager(LoggerContext loggerContext, String string, String string2, boolean bl2, Property[] propertyArray, String string3) {
        super(loggerContext, string);
        this.topic = Objects.requireNonNull(string2, "topic");
        this.syncSend = bl2;
        this.config.setProperty("key.serializer", "com.contrastsecurity.thirdparty.org.apache.kafka.common.serialization.ByteArraySerializer");
        this.config.setProperty("value.serializer", "com.contrastsecurity.thirdparty.org.apache.kafka.common.serialization.ByteArraySerializer");
        this.config.setProperty("batch.size", "0");
        for (Property property : propertyArray) {
            this.config.setProperty(property.getName(), property.getValue());
        }
        this.key = string3;
        this.timeoutMillis = Integers.parseInt(this.config.getProperty("timeout.ms", DEFAULT_TIMEOUT_MILLIS));
    }

    @Override
    public boolean releaseSub(long l2, TimeUnit timeUnit) {
        if (l2 > 0L) {
            this.closeProducer(l2, timeUnit);
        } else {
            this.closeProducer(this.timeoutMillis, TimeUnit.MILLISECONDS);
        }
        return true;
    }

    private void closeProducer(long l2, TimeUnit timeUnit) {
        if (this.producer != null) {
            Log4jThread log4jThread = new Log4jThread(() -> {
                if (this.producer != null) {
                    this.producer.close();
                }
            }, "KafkaManager-CloseThread");
            log4jThread.setDaemon(true);
            log4jThread.start();
            try {
                log4jThread.join(timeUnit.toMillis(l2));
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void send(byte[] byArray) throws ExecutionException, InterruptedException, TimeoutException {
        if (this.producer != null) {
            byte[] byArray2 = null;
            if (this.key != null && this.key.contains("${")) {
                byArray2 = this.getLoggerContext().getConfiguration().getStrSubstitutor().replace(this.key).getBytes(StandardCharsets.UTF_8);
            } else if (this.key != null) {
                byArray2 = this.key.getBytes(StandardCharsets.UTF_8);
            }
            ProducerRecord producerRecord = new ProducerRecord(this.topic, (Object)byArray2, (Object)byArray);
            if (this.syncSend) {
                Future future = this.producer.send(producerRecord);
                future.get(this.timeoutMillis, TimeUnit.MILLISECONDS);
            } else {
                this.producer.send(producerRecord, (recordMetadata, exception) -> {
                    if (exception != null) {
                        LOGGER.error("Unable to write to Kafka in appender [" + this.getName() + "]", (Throwable)exception);
                    }
                });
            }
        }
    }

    public void startup() {
        if (this.producer == null) {
            this.producer = producerFactory.newKafkaProducer(this.config);
        }
    }

    public String getTopic() {
        return this.topic;
    }

    public static KafkaManager getManager(LoggerContext loggerContext, String string, String string2, boolean bl2, Property[] propertyArray, String string3) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(" ").append(string2).append(" ").append(bl2 + "");
        for (Property property : propertyArray) {
            stringBuilder.append(" ").append(property.getName()).append("=").append(property.getValue());
        }
        return KafkaManager.getManager(stringBuilder.toString(), factory, new FactoryData(loggerContext, string2, bl2, propertyArray, string3));
    }

    private static class KafkaManagerFactory
    implements ManagerFactory<KafkaManager, FactoryData> {
        private KafkaManagerFactory() {
        }

        @Override
        public KafkaManager createManager(String string, FactoryData factoryData) {
            return new KafkaManager(factoryData.loggerContext, string, factoryData.topic, factoryData.syncSend, factoryData.properties, factoryData.key);
        }
    }

    private static class FactoryData {
        private final LoggerContext loggerContext;
        private final String topic;
        private final boolean syncSend;
        private final Property[] properties;
        private final String key;

        public FactoryData(LoggerContext loggerContext, String string, boolean bl2, Property[] propertyArray, String string2) {
            this.loggerContext = loggerContext;
            this.topic = string;
            this.syncSend = bl2;
            this.properties = propertyArray;
            this.key = string2;
        }
    }
}

