/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rewrite;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Level;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rewrite.RewritePolicy;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginElement;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.impl.Log4jLogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.KeyValuePair;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

@Plugin(name="LoggerNameLevelRewritePolicy", category="Core", elementType="rewritePolicy", printObject=true)
public class LoggerNameLevelRewritePolicy
implements RewritePolicy {
    private final String loggerName;
    private final Map<Level, Level> map;

    @PluginFactory
    public static LoggerNameLevelRewritePolicy createPolicy(@PluginAttribute(value="logger") String string, @PluginElement(value="KeyValuePair") KeyValuePair[] keyValuePairArray) {
        HashMap<Level, Level> hashMap = new HashMap<Level, Level>(keyValuePairArray.length);
        for (KeyValuePair keyValuePair : keyValuePairArray) {
            hashMap.put(LoggerNameLevelRewritePolicy.getLevel(keyValuePair.getKey()), LoggerNameLevelRewritePolicy.getLevel(keyValuePair.getValue()));
        }
        return new LoggerNameLevelRewritePolicy(string, hashMap);
    }

    private static Level getLevel(String string) {
        return Level.getLevel(string.toUpperCase(Locale.ROOT));
    }

    private LoggerNameLevelRewritePolicy(String string, Map<Level, Level> map) {
        this.loggerName = string;
        this.map = map;
    }

    @Override
    public LogEvent rewrite(LogEvent logEvent) {
        if (logEvent.getLoggerName() == null || !logEvent.getLoggerName().startsWith(this.loggerName)) {
            return logEvent;
        }
        Level level = logEvent.getLevel();
        Level level2 = this.map.get(level);
        if (level2 == null || level2 == level) {
            return logEvent;
        }
        Log4jLogEvent log4jLogEvent = new Log4jLogEvent.Builder(logEvent).setLevel(level2).build();
        return log4jLogEvent;
    }
}

