/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.LoggingException;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.FileExtension;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.action.Action;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.action.CompositeAction;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.lookup.StrSubstitutor;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.NotANumber;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Integers;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractRolloverStrategy
implements RolloverStrategy {
    protected static final Logger LOGGER = StatusLogger.getLogger();
    public static final Pattern PATTERN_COUNTER = Pattern.compile(".*%((?<ZEROPAD>0)?(?<PADDING>\\d+))?i.*");
    protected final StrSubstitutor strSubstitutor;

    protected AbstractRolloverStrategy(StrSubstitutor strSubstitutor) {
        this.strSubstitutor = strSubstitutor;
    }

    public StrSubstitutor getStrSubstitutor() {
        return this.strSubstitutor;
    }

    protected Action merge(Action action, List<Action> list, boolean bl2) {
        if (list.isEmpty()) {
            return action;
        }
        if (action == null) {
            return new CompositeAction(list, bl2);
        }
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.add(action);
        arrayList.addAll(list);
        return new CompositeAction(arrayList, bl2);
    }

    protected int suffixLength(String string) {
        for (FileExtension fileExtension : FileExtension.values()) {
            if (!fileExtension.isExtensionFor(string)) continue;
            return fileExtension.length();
        }
        return 0;
    }

    protected SortedMap<Integer, Path> getEligibleFiles(RollingFileManager rollingFileManager) {
        return this.getEligibleFiles(rollingFileManager, true);
    }

    protected SortedMap<Integer, Path> getEligibleFiles(RollingFileManager rollingFileManager, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = rollingFileManager.getPatternProcessor().getPattern();
        rollingFileManager.getPatternProcessor().formatFileName(this.strSubstitutor, stringBuilder, (Object)NotANumber.NAN);
        String string2 = rollingFileManager.isDirectWrite() ? "" : rollingFileManager.getFileName();
        return this.getEligibleFiles(string2, stringBuilder.toString(), string, bl2);
    }

    protected SortedMap<Integer, Path> getEligibleFiles(String string, String string2) {
        return this.getEligibleFiles("", string, string2, true);
    }

    @Deprecated
    protected SortedMap<Integer, Path> getEligibleFiles(String string, String string2, boolean bl2) {
        return this.getEligibleFiles("", string, string2, bl2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SortedMap<Integer, Path> getEligibleFiles(String string, String string2, String string3, boolean bl2) {
        NavigableMap<Integer, Path> navigableMap;
        TreeMap<Integer, Path> treeMap;
        block18: {
            treeMap = new TreeMap<Integer, Path>();
            File file = new File(string2);
            File file2 = file.getParentFile();
            if (file2 == null) {
                file2 = new File(".");
            } else {
                file2.mkdirs();
            }
            if (!PATTERN_COUNTER.matcher(string3).matches()) {
                return treeMap;
            }
            Path path = file2.toPath();
            String string4 = file.getName();
            int n2 = this.suffixLength(string4);
            string4 = n2 > 0 ? Pattern.quote(string4.substring(0, string4.length() - n2)) + ".*" : Pattern.quote(string4);
            String string5 = string4.replaceFirst("0*\\u0000", "\\\\E(0?\\\\d+)\\\\Q");
            Pattern pattern = Pattern.compile(string5);
            Path path2 = string.length() > 0 ? new File(string).toPath() : null;
            LOGGER.debug("Current file: {}", (Object)string);
            try {
                DirectoryStream<Path> directoryStream;
                block19: {
                    directoryStream = Files.newDirectoryStream(path);
                    Throwable throwable = null;
                    try {
                        for (Path path3 : directoryStream) {
                            Matcher matcher = pattern.matcher(path3.toFile().getName());
                            if (!matcher.matches() || path3.equals(path2)) continue;
                            try {
                                Integer n3 = Integers.parseInt(matcher.group(1));
                                treeMap.put(n3, path3);
                            }
                            catch (NumberFormatException numberFormatException) {
                                LOGGER.debug("Ignoring file {} which matches pattern but the index is invalid.", (Object)path3.toFile().getName());
                            }
                        }
                        if (directoryStream == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable2) {
                        try {
                            Throwable throwable5;
                            Throwables.throwIfCritical(throwable2);
                            throwable = throwable5 = throwable2;
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            if (directoryStream == null) throw throwable6;
                            if (throwable == null) {
                                directoryStream.close();
                                throw throwable6;
                            }
                            try {
                                directoryStream.close();
                                throw throwable6;
                            }
                            catch (Throwable throwable3) {
                                Throwables.throwIfCritical(throwable3);
                                Throwable throwable8 = throwable3;
                                throwable.addSuppressed(throwable8);
                                throw throwable6;
                            }
                        }
                    }
                    try {
                        directoryStream.close();
                    }
                    catch (Throwable throwable4) {
                        Throwables.throwIfCritical(throwable4);
                        Throwable throwable3 = throwable4;
                        throwable.addSuppressed(throwable3);
                    }
                    break block18;
                }
                directoryStream.close();
            }
            catch (IOException iOException) {
                throw new LoggingException("Error reading folder " + path + " " + iOException.getMessage(), iOException);
            }
        }
        if (bl2) {
            navigableMap = treeMap;
            return navigableMap;
        }
        navigableMap = treeMap.descendingMap();
        return navigableMap;
    }
}

