/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.action.Action;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.action.CommonsCompressAction;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.action.GzCompressAction;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.action.ZipCompressAction;
import java.io.File;
import java.util.Objects;

public enum FileExtension {
    ZIP(".zip"){

        @Override
        Action createCompressAction(String string, String string2, boolean bl2, int n2) {
            return new ZipCompressAction(this.source(string), this.target(string2), bl2, n2);
        }
    }
    ,
    GZ(".gz"){

        @Override
        Action createCompressAction(String string, String string2, boolean bl2, int n2) {
            return new GzCompressAction(this.source(string), this.target(string2), bl2, n2);
        }
    }
    ,
    BZIP2(".bz2"){

        @Override
        Action createCompressAction(String string, String string2, boolean bl2, int n2) {
            return new CommonsCompressAction("bzip2", this.source(string), this.target(string2), bl2);
        }
    }
    ,
    DEFLATE(".deflate"){

        @Override
        Action createCompressAction(String string, String string2, boolean bl2, int n2) {
            return new CommonsCompressAction("deflate", this.source(string), this.target(string2), bl2);
        }
    }
    ,
    PACK200(".pack200"){

        @Override
        Action createCompressAction(String string, String string2, boolean bl2, int n2) {
            return new CommonsCompressAction("pack200", this.source(string), this.target(string2), bl2);
        }
    }
    ,
    XZ(".xz"){

        @Override
        Action createCompressAction(String string, String string2, boolean bl2, int n2) {
            return new CommonsCompressAction("xz", this.source(string), this.target(string2), bl2);
        }
    };

    private final String extension;

    public static FileExtension lookup(String string) {
        for (FileExtension fileExtension : FileExtension.values()) {
            if (!fileExtension.isExtensionFor(string)) continue;
            return fileExtension;
        }
        return null;
    }

    public static FileExtension lookupForFile(String string) {
        for (FileExtension fileExtension : FileExtension.values()) {
            if (!string.endsWith(fileExtension.extension)) continue;
            return fileExtension;
        }
        return null;
    }

    private FileExtension(String string2) {
        Objects.requireNonNull(string2, "extension");
        this.extension = string2;
    }

    abstract Action createCompressAction(String var1, String var2, boolean var3, int var4);

    String getExtension() {
        return this.extension;
    }

    boolean isExtensionFor(String string) {
        return string.endsWith(this.extension);
    }

    int length() {
        return this.extension.length();
    }

    File source(String string) {
        return new File(string);
    }

    File target(String string) {
        return new File(string);
    }
}

