/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.AbstractTriggeringPolicy;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.FileSize;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="SizeBasedTriggeringPolicy", category="Core", printObject=true)
public class SizeBasedTriggeringPolicy
extends AbstractTriggeringPolicy {
    private static final long MAX_FILE_SIZE = 0xA00000L;
    private final long maxFileSize;
    private RollingFileManager manager;

    protected SizeBasedTriggeringPolicy() {
        this.maxFileSize = 0xA00000L;
    }

    protected SizeBasedTriggeringPolicy(long l2) {
        this.maxFileSize = l2;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    @Override
    public void initialize(RollingFileManager rollingFileManager) {
        this.manager = rollingFileManager;
    }

    @Override
    public boolean isTriggeringEvent(LogEvent logEvent) {
        boolean bl2;
        boolean bl3 = bl2 = this.manager.getFileSize() > this.maxFileSize;
        if (bl2) {
            this.manager.getPatternProcessor().updateTime();
        }
        return bl2;
    }

    public String toString() {
        return "SizeBasedTriggeringPolicy(size=" + this.maxFileSize + ')';
    }

    @PluginFactory
    public static SizeBasedTriggeringPolicy createPolicy(@PluginAttribute(value="size") String string) {
        long l2 = string == null ? 0xA00000L : FileSize.parse(string, 0xA00000L);
        return new SizeBasedTriggeringPolicy(l2);
    }
}

