/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.action;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.action.AbstractAction;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.action.Action;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class CompositeAction
extends AbstractAction {
    private final Action[] actions;
    private final boolean stopOnError;

    public CompositeAction(List<Action> list, boolean bl2) {
        this.actions = new Action[list.size()];
        list.toArray(this.actions);
        this.stopOnError = bl2;
    }

    @Override
    public void run() {
        try {
            this.execute();
        }
        catch (IOException iOException) {
            LOGGER.warn("Exception during file rollover.", (Throwable)iOException);
        }
    }

    @Override
    public boolean execute() throws IOException {
        if (this.stopOnError) {
            for (Action action : this.actions) {
                if (action.execute()) continue;
                return false;
            }
            return true;
        }
        boolean bl2 = true;
        IOException iOException = null;
        for (Action action : this.actions) {
            try {
                bl2 &= action.execute();
            }
            catch (IOException iOException2) {
                bl2 = false;
                if (iOException != null) continue;
                iOException = iOException2;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
        return bl2;
    }

    public String toString() {
        return CompositeAction.class.getSimpleName() + Arrays.toString(this.actions);
    }

    public Action[] getActions() {
        return this.actions;
    }

    public boolean isStopOnError() {
        return this.stopOnError;
    }
}

