/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.action;

import com.contrastsecurity.agent.commons.Throwables;
import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Duration
implements Serializable,
Comparable<Duration> {
    private static final long serialVersionUID = -3756810052716342061L;
    public static final Duration ZERO = new Duration(0L);
    private static final int HOURS_PER_DAY = 24;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_DAY = 86400;
    private static final Pattern PATTERN = Pattern.compile("P?(?:([0-9]+)D)?(T?(?:([0-9]+)H)?(?:([0-9]+)M)?(?:([0-9]+)?S)?)?", 2);
    private final long seconds;

    private Duration(long l2) {
        this.seconds = l2;
    }

    public static Duration parse(CharSequence charSequence) {
        Objects.requireNonNull(charSequence, "text");
        Matcher matcher = PATTERN.matcher(charSequence);
        if (matcher.matches() && !"T".equals(matcher.group(2))) {
            String string = matcher.group(1);
            String string2 = matcher.group(3);
            String string3 = matcher.group(4);
            String string4 = matcher.group(5);
            if (string != null || string2 != null || string3 != null || string4 != null) {
                long l2 = Duration.parseNumber(charSequence, string, 86400, "days");
                long l3 = Duration.parseNumber(charSequence, string2, 3600, "hours");
                long l4 = Duration.parseNumber(charSequence, string3, 60, "minutes");
                long l5 = Duration.parseNumber(charSequence, string4, 1, "seconds");
                try {
                    return Duration.create(l2, l3, l4, l5);
                }
                catch (ArithmeticException arithmeticException) {
                    throw new IllegalArgumentException("Text cannot be parsed to a Duration (overflow) " + charSequence, arithmeticException);
                }
            }
        }
        throw new IllegalArgumentException("Text cannot be parsed to a Duration: " + charSequence);
    }

    private static long parseNumber(CharSequence charSequence, String string, int n2, String string2) {
        if (string == null) {
            return 0L;
        }
        try {
            long l2 = Long.parseLong(string);
            return l2 * (long)n2;
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            throw new IllegalArgumentException("Text cannot be parsed to a Duration: " + string2 + " (in " + charSequence + ")", exception2);
        }
    }

    private static Duration create(long l2, long l3, long l4, long l5) {
        return Duration.create(l2 + l3 + l4 + l5);
    }

    private static Duration create(long l2) {
        if (l2 == 0L) {
            return ZERO;
        }
        return new Duration(l2);
    }

    public long toMillis() {
        return this.seconds * 1000L;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Duration)) {
            return false;
        }
        Duration duration = (Duration)object;
        return duration.seconds == this.seconds;
    }

    public int hashCode() {
        return (int)(this.seconds ^ this.seconds >>> 32);
    }

    public String toString() {
        if (this == ZERO) {
            return "PT0S";
        }
        long l2 = this.seconds / 86400L;
        long l3 = this.seconds % 86400L / 3600L;
        int n2 = (int)(this.seconds % 3600L / 60L);
        int n3 = (int)(this.seconds % 60L);
        StringBuilder stringBuilder = new StringBuilder(24);
        stringBuilder.append("P");
        if (l2 != 0L) {
            stringBuilder.append(l2).append('D');
        }
        if ((l3 | (long)n2 | (long)n3) != 0L) {
            stringBuilder.append('T');
        }
        if (l3 != 0L) {
            stringBuilder.append(l3).append('H');
        }
        if (n2 != 0) {
            stringBuilder.append(n2).append('M');
        }
        if (n3 == 0 && stringBuilder.length() > 0) {
            return stringBuilder.toString();
        }
        stringBuilder.append(n3).append('S');
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(Duration duration) {
        return Long.signum(this.toMillis() - duration.toMillis());
    }
}

